/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal;

import java.util.LinkedHashSet;
import org.eclipse.gyrex.admin.ui.cloud.internal.NodeBrowserContentProvider;
import org.eclipse.gyrex.admin.ui.internal.widgets.PatternFilter;
import org.eclipse.jface.viewers.Viewer;

public class NodePatternFilter
extends PatternFilter {
    private static final long serialVersionUID = 1L;

    public NodePatternFilter() {
        this.setIncludeLeadingWildcard(true);
    }

    public boolean isElementSelectable(Object element) {
        return super.isElementSelectable(element);
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        return super.isElementVisible(viewer, element);
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        if (element instanceof NodeBrowserContentProvider.NodeItem) {
            NodeBrowserContentProvider.NodeItem nodeItem = (NodeBrowserContentProvider.NodeItem)element;
            LinkedHashSet<String> keywords = new LinkedHashSet<String>();
            keywords.add(nodeItem.getDescriptor().getId());
            keywords.add(nodeItem.getDescriptor().getName());
            keywords.add(nodeItem.getDescriptor().getLocation());
            keywords.addAll(nodeItem.getDescriptor().getTags());
            if (nodeItem.isApproved()) {
                keywords.add("approved");
            } else {
                keywords.add("pending");
            }
            if (nodeItem.isOnline()) {
                keywords.add("online");
            }
            for (String word : keywords) {
                if (!this.wordMatches(word)) continue;
                return true;
            }
        }
        return super.isLeafMatch(viewer, element);
    }
}

