/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.server.PurgeTxnLog;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.boot.internal.app.ServerApplication;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGateApplication;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGateConfig;
import org.eclipse.gyrex.common.internal.applications.BaseApplication;
import org.eclipse.gyrex.server.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServerApplication
extends BaseApplication {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperServerApplication.class);
    static volatile ZooKeeperGateApplication connectedGateApplication;
    private ZooKeeperServer zkServer;
    private Object factory;

    public ZooKeeperServerApplication() {
        this.debug = CloudDebug.zooKeeperServer;
    }

    protected void doStart(Map<?, ?> arguments) throws Exception {
        try {
            this.runStandaloneEmbedded();
        }
        catch (Exception e) {
            if (Platform.inDevelopmentMode()) {
                ServerApplication.shutdown((Throwable)new Exception("Could not start the embedded ZooKeeper server. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e));
            } else {
                LOG.error("Unable to start embedded ZooKeeper. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)e);
            }
            throw new BaseApplication.StartAbortedException();
        }
    }

    protected Object doStop() {
        ZooKeeperGateApplication gateApp = connectedGateApplication;
        if (gateApp != null) {
            connectedGateApplication = null;
            try {
                gateApp.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (CloudDebug.zooKeeperServer) {
                LOG.debug("Preparing for ZooKeeper shutdown...");
            }
            Thread.sleep(250L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.factory != null) {
            if (CloudDebug.zooKeeperServer) {
                LOG.debug("Shutting down standalone ZooKeeper server...");
            }
            try {
                this.factory.getClass().getMethod("shutdown", new Class[0]).invoke(this.factory, new Object[0]);
            }
            catch (Exception e) {
                LOG.error("Error stopping server {}. {}", new Object[]{this.factory, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
            this.factory = null;
            if (this.zkServer.isRunning()) {
                this.zkServer.shutdown();
            }
            this.zkServer = null;
            LOG.info("ZooKeeper server stopped.");
        }
        return EXIT_OK;
    }

    protected Logger getLogger() {
        return LOG;
    }

    private void runStandaloneEmbedded() throws Exception {
        System.setProperty("zookeeper.jmx.log4j.disable", Boolean.TRUE.toString());
        IPath zkBase = Platform.getInstanceLocation().append("zookeeper");
        File dataDir = zkBase.append("logs").toFile();
        File snapDir = zkBase.toFile();
        PurgeTxnLog.purge((File)dataDir, (File)snapDir, (int)3);
        this.zkServer = new ZooKeeperServer();
        this.zkServer.setTxnLogFactory(new FileTxnSnapLog(dataDir, snapDir));
        this.zkServer.setTickTime(3000);
        this.zkServer.setMinSessionTimeout(6000);
        this.zkServer.setMaxSessionTimeout(30000);
        int port = ZooKeeperGateConfig.getDefaultPort();
        this.factory = ServerCnxnFactory.createFactory((InetSocketAddress)new InetSocketAddress(port), (int)10);
        LOG.info("Starting ZooKeeper standalone server.");
        this.factory.getClass().getMethod("startup", ZooKeeperServer.class).invoke(this.factory, this.zkServer);
    }
}

