/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.externalprocess;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.jobs.IJobContext;
import org.eclipse.gyrex.jobs.internal.externalprocess.ExternalProcessJob;
import org.eclipse.gyrex.jobs.internal.externalprocess.ExternalProcessJobParameter;
import org.eclipse.gyrex.jobs.provider.JobProvider;

public class ExternalProcessJobProvider
extends JobProvider {
    public static final String JOB_TYPE_ID = "org.eclipse.gyrex.jobs.system.externalprocess";

    public ExternalProcessJobProvider() {
        super(Arrays.asList(JOB_TYPE_ID));
    }

    private ExternalProcessJob create(IJobContext context) {
        ExternalProcessJobParameter parameter = ExternalProcessJobParameter.fromParameter(context.getParameter(), true);
        if (StringUtils.isBlank((String)parameter.getCommand())) {
            throw new IllegalArgumentException("command must not be blank");
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(parameter.getCommand());
        if (parameter.getArguments() != null) {
            commandLine.addAll(parameter.getArguments());
        }
        ExternalProcessJob job = new ExternalProcessJob(context.getJobId(), commandLine, null);
        if (parameter.getExpectedReturnCode() != null) {
            job.setExitValue(parameter.getExpectedReturnCode());
        }
        if (parameter.getClearEnvironment() != null) {
            job.setClearEnvironment(parameter.getClearEnvironment());
        }
        if (parameter.getEnvironment() != null) {
            job.setAdditionalEnvironment(parameter.getEnvironment());
        }
        if (StringUtils.isNotBlank((String)parameter.getWorkingDir())) {
            job.setWorkingDirectory(new File(parameter.getWorkingDir()));
        }
        return job;
    }

    @Override
    public Job createJob(String typeId, IJobContext context) throws Exception {
        switch (typeId) {
            case "org.eclipse.gyrex.jobs.system.externalprocess": {
                return this.create(context);
            }
        }
        return null;
    }
}

