/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.metrics;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.eclipse.gyrex.monitoring.metrics.BaseMetric;
import org.eclipse.gyrex.monitoring.metrics.Counter;
import org.eclipse.gyrex.monitoring.metrics.MetricAttribute;

public class ThroughputMetric
extends BaseMetric {
    private volatile long requestsActive;
    private volatile long requestsStatsHigh;
    private volatile long requestsStatsProcessed;
    private volatile long requestsStatsHitRatePerHour;
    private volatile long requestsStatsHitRatePerMinute;
    private volatile long requestsStatsHitRatePerSecond;
    private volatile long requestsStatsFailed;
    private volatile float requestsStatsFailureRate;
    private volatile long requestsStatsSize;
    private volatile long requestsStatsSizeAverage;
    private final Counter requestsStatsProcessingTime = new Counter();
    private final TimeUnit timeUnit;

    public ThroughputMetric(String id) {
        this(id, TimeUnit.MILLISECONDS);
    }

    public ThroughputMetric(String id, TimeUnit timeUnit) {
        super(id);
        if (timeUnit == null) {
            throw new IllegalArgumentException("no time unit specified");
        }
        this.timeUnit = timeUnit;
    }

    @Override
    void doResetStats() {
        this.requestsStatsHigh = 0L;
        this.requestsStatsProcessed = 0L;
        this.requestsStatsHitRatePerMinute = 0L;
        this.requestsStatsFailed = 0L;
        this.requestsStatsHigh = 0L;
        this.requestsStatsSize = 0L;
        this.requestsStatsSizeAverage = 0L;
        this.requestsStatsProcessingTime.reset();
    }

    @Override
    Object[] dumpMetrics() {
        return new Object[]{"active|high|processed|rate|size|size average|time|time average|time high|time low|time stddev", this.getRequestsActive(), this.getRequestsStatsHigh(), this.getRequestsStatsProcessed(), this.getRequestsStatsHitRatePerMinute(), this.getRequestsStatsSize(), this.getRequestsStatsSizeAverage(), this.getRequestsStatsProcessingTime(), this.getRequestsStatsProcessingTimeAverage(), this.getRequestsStatsProcessingTimeHigh(), this.getRequestsStatsProcessingTimeLow(), this.getRequestsStatsProcessingTimeStandardDeviation()};
    }

    public long getRequestsActive() {
        return this.requestsActive;
    }

    public long getRequestsStatsFailed() {
        return this.requestsStatsFailed;
    }

    public float getRequestsStatsFailureRate() {
        return this.requestsStatsFailureRate;
    }

    public long getRequestsStatsHigh() {
        return this.requestsStatsHigh;
    }

    public long getRequestsStatsHitRatePerHour() {
        Lock writeLock = this.getWriteLock();
        if (writeLock.tryLock()) {
            try {
                this.updateHitRate();
            }
            finally {
                writeLock.unlock();
            }
        }
        return this.requestsStatsHitRatePerHour;
    }

    public long getRequestsStatsHitRatePerMinute() {
        Lock writeLock = this.getWriteLock();
        if (writeLock.tryLock()) {
            try {
                this.updateHitRate();
            }
            finally {
                writeLock.unlock();
            }
        }
        return this.requestsStatsHitRatePerMinute;
    }

    public long getRequestsStatsHitRatePerSecond() {
        Lock writeLock = this.getWriteLock();
        if (writeLock.tryLock()) {
            try {
                this.updateHitRate();
            }
            finally {
                writeLock.unlock();
            }
        }
        return this.requestsStatsHitRatePerSecond;
    }

    public long getRequestsStatsProcessed() {
        return this.requestsStatsProcessed;
    }

    public long getRequestsStatsProcessingTime() {
        return this.requestsStatsProcessingTime.getValue();
    }

    public long getRequestsStatsProcessingTimeAverage() {
        return this.requestsStatsProcessingTime.getAverage();
    }

    public long getRequestsStatsProcessingTimeHigh() {
        return this.requestsStatsProcessingTime.getHigh();
    }

    public long getRequestsStatsProcessingTimeLow() {
        return this.requestsStatsProcessingTime.getLow();
    }

    public double getRequestsStatsProcessingTimeStandardDeviation() {
        return Math.sqrt(this.getRequestsStatsProcessingTimeVariance());
    }

    public double getRequestsStatsProcessingTimeVariance() {
        Lock lock = this.getReadLock();
        lock.lock();
        try {
            double d = this.requestsStatsProcessingTime.getVariance();
            return d;
        }
        finally {
            lock.unlock();
        }
    }

    public long getRequestsStatsSize() {
        return this.requestsStatsSize;
    }

    public long getRequestsStatsSizeAverage() {
        return this.requestsStatsSizeAverage;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    void populateAttributes(List<MetricAttribute> attributes) {
        super.populateAttributes(attributes);
        attributes.add(new MetricAttribute("requestsActive", "the number of active requests", Long.class));
        attributes.add(new MetricAttribute("requestsStatsHigh", "the high water mark since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("requestsStatsProcessed", " the total number of requests processed (excluding failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("requestsStatsHitRatePerHour", "the request hit rate per hour (including failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("requestsStatsHitRatePerMinute", "the request hit rate per minute (including failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("requestsStatsHitRatePerSecond", "the request hit rate per second (including failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("requestsStatsFailed", "the total number of failed requests since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("requestsStatsFailureRate", "the request failure rate since the last statistics reset (percentage of failed requests vs. processed + failed requests)", Float.class));
        attributes.add(new MetricAttribute("requestsStatsSize", "the total number of size units processed by requests (excluding failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("requestsStatsSizeAverage", "the average number of size units processed by a request (excluding failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("requestsStatsProcessingTime", "the total number of time consumed processing requests (excluding failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("requestsStatsProcessingTimeAverage", "the average number of time consumed processing a request (excluding failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("requestsStatsProcessingTimeHigh", "the highest number of time consumed processing a request (excluding failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("requestsStatsProcessingTimeLow", "the lowest number of time consumed processing a request (excluding failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("requestsStatsProcessingTimeStandardDeviation", "the standard deviation for the total number of time consumed processing requests (excluding failed requests) since the last statistics reset", Double.class));
        attributes.add(new MetricAttribute("timeUnit", "the time unit used in the metric", String.class));
    }

    @Override
    void populateAttributeValues(Map<String, Object> values) {
        super.populateAttributeValues(values);
        values.put("requestsActive", this.getRequestsActive());
        values.put("requestsStatsHigh", this.getRequestsStatsHigh());
        values.put("requestsStatsProcessed", this.getRequestsStatsProcessed());
        values.put("requestsStatsHitRatePerHour", this.getRequestsStatsHitRatePerHour());
        values.put("requestsStatsHitRatePerMinute", this.getRequestsStatsHitRatePerMinute());
        values.put("requestsStatsHitRatePerSecond", this.getRequestsStatsHitRatePerSecond());
        values.put("requestsStatsFailed", this.getRequestsStatsFailed());
        values.put("requestsStatsFailureRate", Float.valueOf(this.getRequestsStatsFailureRate()));
        values.put("requestsStatsSize", this.getRequestsStatsSize());
        values.put("requestsStatsSizeAverage", this.getRequestsStatsSizeAverage());
        values.put("requestsStatsProcessingTime", this.getRequestsStatsProcessingTime());
        values.put("requestsStatsProcessingTimeAverage", this.getRequestsStatsProcessingTimeAverage());
        values.put("requestsStatsProcessingTimeHigh", this.getRequestsStatsProcessingTimeHigh());
        values.put("requestsStatsProcessingTimeLow", this.getRequestsStatsProcessingTimeLow());
        values.put("requestsStatsProcessingTimeStandardDeviation", this.getRequestsStatsProcessingTimeStandardDeviation());
        values.put("timeUnit", this.getTimeUnit().toString());
    }

    public void requestFailed() {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            --this.requestsActive;
            ++this.requestsStatsFailed;
            this.updateHitRate();
        }
        finally {
            writeLock.unlock();
        }
    }

    public void requestFinished(long sizeUnits, long processingTime) {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            --this.requestsActive;
            ++this.requestsStatsProcessed;
            this.requestsStatsSize += sizeUnits;
            this.requestsStatsSizeAverage = this.requestsStatsSize / this.requestsStatsProcessed;
            this.requestsStatsProcessingTime.increment(processingTime);
            this.updateHitRate();
            this.updateFailureRate();
        }
        finally {
            writeLock.unlock();
        }
    }

    public long requestStarted() {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            ++this.requestsActive;
            if (this.requestsActive > this.requestsStatsHigh) {
                this.requestsStatsHigh = this.requestsActive;
            }
            this.updateHitRate();
            this.updateFailureRate();
        }
        finally {
            writeLock.unlock();
        }
        switch (this.timeUnit) {
            case NANOSECONDS: {
                return System.nanoTime();
            }
            case MICROSECONDS: {
                return TimeUnit.NANOSECONDS.toMicros(System.nanoTime());
            }
            case MILLISECONDS: {
                return System.currentTimeMillis();
            }
        }
        return this.getTimeUnit().convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    private void updateFailureRate() {
        long total = this.requestsStatsFailed + this.requestsStatsProcessed;
        this.requestsStatsFailureRate = total == 0L ? 0L : this.requestsStatsFailed / total * 100L;
    }

    private void updateHitRate() {
        long totalRequestProcessed = this.requestsStatsProcessed + this.requestsStatsFailed;
        long duration = System.currentTimeMillis() - this.getStatsSinceTS();
        long durationSeconds = duration / 1000L;
        long durationMinutes = duration / 60000L;
        long durationHours = duration / 3600000L;
        this.requestsStatsHitRatePerSecond = durationSeconds == 0L || totalRequestProcessed == 0L ? 0L : totalRequestProcessed / durationSeconds;
        this.requestsStatsHitRatePerMinute = durationMinutes == 0L || totalRequestProcessed == 0L ? 0L : totalRequestProcessed / durationMinutes;
        this.requestsStatsHitRatePerHour = durationHours == 0L || totalRequestProcessed == 0L ? 0L : totalRequestProcessed / durationHours;
    }
}

