/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal.commonapenders;

import ch.qos.logback.core.joran.spi.ConsoleTarget;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DescriptionDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.admin.ui.logback.configuration.wizard.AppenderConfigurationWizardSession;
import org.eclipse.gyrex.logback.config.model.ConsoleAppender;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ConsoleAppenderWizardPage
extends WizardPage {
    private static final int INDEX_STD_ERR = 1;
    private static final long serialVersionUID = 1L;
    private final StringDialogField patternField = new StringDialogField();
    private final DescriptionDialogField patternDescriptionField = new DescriptionDialogField();
    private final ConsoleAppender appender;
    SelectionButtonDialogFieldGroup targetGroup = new SelectionButtonDialogFieldGroup(16, new String[]{"STDOUT", "STDERR"}, 2);

    public ConsoleAppenderWizardPage(AppenderConfigurationWizardSession session) {
        super("console");
        this.setTitle("Console Appender");
        this.setDescription("Configure details for a console appender.");
        this.appender = (ConsoleAppender)Preconditions.checkNotNull((Object)session.getAppender());
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(this.convertVerticalDLUsToPixels(200), this.convertHorizontalDLUsToPixels(400)).create());
        this.setControl((Control)composite);
        this.targetGroup.setLabelText("Output to:");
        this.patternField.setLabelText("Pattern:");
        this.patternDescriptionField.setText("<small>Please have a look at <a href=\"http://logback.qos.ch/\">the Logback documentation</a> for possible patterns or leave empty for a system default.</small>");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ConsoleAppenderWizardPage.this.validate();
            }
        };
        this.patternField.setDialogFieldListener(validateListener);
        this.targetGroup.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.targetGroup, new Separator(), this.patternField, this.patternDescriptionField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.targetGroup.getSelectionButtonsGroup(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.patternField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.patternDescriptionField.getDescriptionControl(null));
    }

    public String getPattern() {
        return this.patternField.getText();
    }

    private ConsoleTarget getTarget() {
        return this.targetGroup.isSelected(1) ? ConsoleTarget.SystemErr : ConsoleTarget.SystemOut;
    }

    public void setVisible(boolean visible) {
        if (StringUtils.isNotBlank((String)this.appender.getPattern())) {
            this.patternField.setText(this.appender.getPattern());
        }
        if (this.appender.getTarget() == ConsoleTarget.SystemErr) {
            this.targetGroup.setSelection(1, true);
        }
        super.setVisible(visible);
    }

    void validate() {
        String pattern = this.getPattern();
        this.appender.setPattern(StringUtils.isBlank((String)pattern) ? null : pattern);
        this.appender.setTarget(this.getTarget());
        this.setMessage(null);
        this.setPageComplete(true);
    }
}

