/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.logback.config.model;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.sift.MDCBasedDiscriminator;
import ch.qos.logback.classic.sift.SiftingAppender;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.logback.config.model.LobackConfigElement;

public abstract class Appender
extends LobackConfigElement {
    private final String typeId;
    private String name;
    private String pattern;
    private Level threshold;
    private String siftingMdcPropertyName;
    private String siftingMdcPropertyDefaultValue;

    public Appender(String typeId) {
        if (!IdHelper.isValidId((String)typeId)) {
            throw new IllegalArgumentException("invalid type id: " + typeId);
        }
        this.typeId = typeId;
    }

    public boolean canSift() {
        return false;
    }

    protected abstract String getAppenderClassName();

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getSiftingMdcPropertyDefaultValue() {
        return this.siftingMdcPropertyDefaultValue;
    }

    public String getSiftingMdcPropertyName() {
        return this.siftingMdcPropertyName;
    }

    public Level getThreshold() {
        return this.threshold;
    }

    public final String getTypeId() {
        return this.typeId;
    }

    public boolean isSeparateLogOutputsPerMdcProperty() {
        return this.getSiftingMdcPropertyName() != null && this.getSiftingMdcPropertyDefaultValue() != null;
    }

    protected boolean preferShortPattern() {
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setSiftingMdcPropertyDefaultValue(String siftingMdcPropertyDefaultValue) {
        this.siftingMdcPropertyDefaultValue = siftingMdcPropertyDefaultValue;
    }

    public void setSiftingMdcPropertyName(String siftingMdcPropertyName) {
        this.siftingMdcPropertyName = siftingMdcPropertyName;
    }

    public void setThreshold(Level threshold) {
        this.threshold = threshold;
    }

    @Override
    public void toXml(XMLStreamWriter writer) throws XMLStreamException {
        boolean wrapIntoSiftingAppender = this.canSift() && this.isSeparateLogOutputsPerMdcProperty();
        writer.writeStartElement("appender");
        writer.writeAttribute("name", this.getName());
        if (wrapIntoSiftingAppender) {
            writer.writeAttribute("class", SiftingAppender.class.getName());
        } else {
            writer.writeAttribute("class", this.getAppenderClassName());
        }
        Level threshold = this.getThreshold();
        if (threshold != null) {
            writer.writeStartElement("filter");
            writer.writeAttribute("class", ThresholdFilter.class.getName());
            writer.writeStartElement("level");
            writer.writeCharacters(threshold.toString());
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (wrapIntoSiftingAppender) {
            writer.writeStartElement("discriminator");
            writer.writeAttribute("class", MDCBasedDiscriminator.class.getName());
            writer.writeStartElement("key");
            writer.writeCharacters(this.getSiftingMdcPropertyName());
            writer.writeEndElement();
            writer.writeStartElement("defaultValue");
            writer.writeCharacters(this.getSiftingMdcPropertyDefaultValue());
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("sift");
            writer.writeStartElement("appender");
            writer.writeAttribute("name", String.format("%s-${%s}", this.getName(), this.getSiftingMdcPropertyName()));
        }
        this.writeAppenderContent(writer);
        this.writeEncoder(writer);
        if (wrapIntoSiftingAppender) {
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    protected void writeAppenderContent(XMLStreamWriter writer) throws XMLStreamException {
    }

    private void writeEncoder(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("encoder");
        writer.writeStartElement("pattern");
        String text = this.getPattern();
        if (StringUtils.isBlank((String)text)) {
            text = this.preferShortPattern() ? "${PATTERN_SHORT}" : "${PATTERN_LONG}";
        } else if (StringUtils.containsIgnoreCase((String)text, (String)"PATTERN_LONG")) {
            text = "${PATTERN_LONG}";
        } else if (StringUtils.containsIgnoreCase((String)text, (String)"PATTERN_SHORT")) {
            text = "${PATTERN_SHORT}";
        }
        writer.writeCharacters(text);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

