/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.registry.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.gyrex.http.registry.internal.ApplicationRegistryManager;
import org.eclipse.gyrex.http.registry.internal.ExtensionPointTracker;
import org.eclipse.gyrex.http.registry.internal.HttpRegistryDebug;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletManager
implements ExtensionPointTracker.Listener {
    private static final String SERVLETS_EXTENSION_POINT = "org.eclipse.gyrex.http.applications";
    private static final String PARAM_VALUE = "value";
    private static final String PARAM_NAME = "name";
    private static final String INIT_PARAM = "init-param";
    private static final String SERVLET = "servlet";
    private static final String ALIAS = "alias";
    private static final String LOAD_ON_STARTUP = "load-on-startup";
    private static final String APPLICATION_ID = "applicationId";
    private static final Logger LOG = LoggerFactory.getLogger(ServletManager.class);
    private final ExtensionPointTracker tracker;
    private final ApplicationRegistryManager httpRegistryManager;
    private final List<IConfigurationElement> registered = new ArrayList<IConfigurationElement>();

    public ServletManager(ApplicationRegistryManager httpRegistryManager, ServiceReference reference, IExtensionRegistry registry) {
        this.httpRegistryManager = httpRegistryManager;
        this.tracker = new ExtensionPointTracker(registry, SERVLETS_EXTENSION_POINT, this);
    }

    @Override
    public void added(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement servletElement = elements[i];
            if (SERVLET.equals(servletElement.getName())) {
                ServletWrapper wrapper = new ServletWrapper(servletElement);
                String alias = servletElement.getAttribute(ALIAS);
                if (alias == null) {
                    LOG.warn("Ignoring servlet extension element contributed by {}. Does not contain an alias.", (Object)servletElement.getContributor());
                } else {
                    String applicationId;
                    HashMap<String, String> initparams = new HashMap<String, String>();
                    IConfigurationElement[] initParams = servletElement.getChildren(INIT_PARAM);
                    int j = 0;
                    while (j < initParams.length) {
                        String paramName = initParams[j].getAttribute(PARAM_NAME);
                        String paramValue = initParams[j].getAttribute(PARAM_VALUE);
                        initparams.put(paramName, paramValue);
                        ++j;
                    }
                    boolean loadOnStartup = new Boolean(servletElement.getAttribute(LOAD_ON_STARTUP));
                    if (loadOnStartup) {
                        wrapper.setLoadOnStartup();
                    }
                    if ((applicationId = servletElement.getAttribute(APPLICATION_ID)) == null) {
                        LOG.warn("Ignoring servlet extension element contributed by {}. Does not contain an application id.", (Object)servletElement.getContributor());
                    } else {
                        if (applicationId.indexOf(46) == -1) {
                            applicationId = String.valueOf(servletElement.getNamespaceIdentifier()) + "." + applicationId;
                        }
                        if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Trying to add servlet {} to application {} (contributed by {}).", new Object[]{alias, applicationId, servletElement.getContributor()});
                        }
                        if (this.httpRegistryManager.addServletContribution(alias, wrapper, initparams, applicationId, extension.getContributor())) {
                            if (HttpRegistryDebug.extensionRegistration) {
                                LOG.debug("Successfully added servlet {} to application {} (contributed by {}).", new Object[]{alias, applicationId, servletElement.getContributor()});
                            }
                            this.registered.add(servletElement);
                        } else if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Did not add servlet {} to application {} (contributed by {}).", new Object[]{alias, applicationId, servletElement.getContributor()});
                        }
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void removed(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement servletElement = elements[i];
            if (SERVLET.equals(servletElement.getName())) {
                String alias = servletElement.getAttribute(ALIAS);
                if (alias == null) {
                    LOG.warn("Ignoring mount extension element contributed by {}. Does not contain an alias.", (Object)servletElement.getContributor());
                } else {
                    String applicationId = servletElement.getAttribute(APPLICATION_ID);
                    if (applicationId == null) {
                        LOG.warn("Ignoring mount extension element contributed by {}. Does not contain an application id.", (Object)servletElement.getContributor());
                    } else {
                        if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Trying to remove servlet {} to application {} (contributed by {}).", new Object[]{alias, applicationId, servletElement.getContributor()});
                        }
                        if (this.registered.remove(servletElement)) {
                            if (HttpRegistryDebug.extensionRegistration) {
                                LOG.debug("Successfully removed servlet {} to application {} (contributed by {}).", new Object[]{alias, applicationId, servletElement.getContributor()});
                            }
                            this.httpRegistryManager.removeContribution(alias, applicationId);
                        } else if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Did not remove servlet {} to application {} (contributed by {}).", new Object[]{alias, applicationId, servletElement.getContributor()});
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    private static class ServletWrapper
    implements Servlet {
        private static final String CLASS = "class";
        private final IConfigurationElement element;
        private Servlet delegate;
        private ServletConfig config;
        private boolean loadOnStartup = false;

        public ServletWrapper(IConfigurationElement element) {
            this.element = element;
        }

        public void destroy() {
            this.destroyDelegate();
        }

        private void destroyDelegate() {
            if (this.delegate != null) {
                Servlet doomedDelegate = this.delegate;
                this.delegate = null;
                doomedDelegate.destroy();
            }
        }

        public ServletConfig getServletConfig() {
            return this.config;
        }

        public String getServletInfo() {
            return "";
        }

        public void init(ServletConfig config) throws ServletException {
            this.config = config;
            if (this.loadOnStartup) {
                this.initializeDelegate();
            }
        }

        private void initializeDelegate() throws ServletException {
            if (this.delegate == null) {
                try {
                    Servlet newDelegate = (Servlet)this.element.createExecutableExtension(CLASS);
                    newDelegate.init(this.config);
                    this.delegate = newDelegate;
                }
                catch (CoreException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }

        public void service(ServletRequest arg0, ServletResponse arg1) throws ServletException, IOException {
            this.initializeDelegate();
            this.delegate.service(arg0, arg1);
        }

        public void setLoadOnStartup() {
            this.loadOnStartup = true;
        }
    }
}

