/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.p2.internal;

import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.Infobox;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.admin.ui.p2.internal.EditPackageDialog;
import org.eclipse.gyrex.admin.ui.p2.internal.P2UiLabelProvider;
import org.eclipse.gyrex.admin.ui.p2.internal.PackageContentProvider;
import org.eclipse.gyrex.admin.ui.p2.internal.RepositoriesListDialog;
import org.eclipse.gyrex.p2.internal.P2Activator;
import org.eclipse.gyrex.p2.internal.packages.IPackageManager;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.eclipse.gyrex.p2.internal.repositories.IRepositoryDefinitionManager;
import org.eclipse.gyrex.rap.application.Page;
import org.eclipse.gyrex.rap.helper.SwtUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SoftwareLandingPage
extends Page {
    private Composite pageComposite;
    private Link manageRepos;
    private ISelectionChangedListener updateButtonsListener;
    private ListViewer packagesViewer;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button provisionButton;
    private Button revokeButton;

    public SoftwareLandingPage() {
        this.setTitle("Software Provisioning");
        this.setTitleToolTip("Install, update and remove software.");
    }

    public void activate() {
        super.activate();
        if (this.packagesViewer != null) {
            this.packagesViewer.setInput((Object)this.getPackageManager());
            this.updateButtonsListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SoftwareLandingPage.this.updateButtons();
                }
            };
            this.packagesViewer.addSelectionChangedListener(this.updateButtonsListener);
            this.packagesViewer.getControl().getDisplay();
        }
    }

    void addButtonPressed() {
        EditPackageDialog dialog = new EditPackageDialog(SwtUtil.getShell((Widget)this.addButton), this.getPackageManager(), null);
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    SoftwareLandingPage.this.refresh();
                }
            }
        });
    }

    private Button createButton(Composite buttons, String buttonLabel) {
        Button b = new Button(buttons, 0);
        b.setText(buttonLabel);
        b.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return b;
    }

    protected void createButtons(Composite buttonsPanel) {
        this.addButton = this.createButton(buttonsPanel, "Add...");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                SoftwareLandingPage.this.addButtonPressed();
            }
        });
        this.editButton = this.createButton(buttonsPanel, "Edit...");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                SoftwareLandingPage.this.editSelectedPackage();
            }
        });
        this.removeButton = this.createButton(buttonsPanel, "Remove...");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                SoftwareLandingPage.this.removeButtonPressed();
            }
        });
        this.createButtonsSeparator(buttonsPanel);
        this.provisionButton = this.createButton(buttonsPanel, "Provision");
        this.provisionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                SoftwareLandingPage.this.provisionButtonPressed();
            }
        });
        this.revokeButton = this.createButton(buttonsPanel, "Revoke");
        this.revokeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                SoftwareLandingPage.this.revokeButtonPressed();
            }
        });
    }

    private Label createButtonsSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        separator.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        return separator;
    }

    public Control createControl(Composite parent) {
        this.pageComposite = new Composite(parent, 0);
        this.pageComposite.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin((int)1, (boolean)false));
        Infobox infobox = new Infobox(this.pageComposite);
        infobox.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        infobox.addHeading("Manage software packages");
        infobox.addParagraph("This page offers the possibillty to manage software packages. Create packages of features provided from p2 repositories.");
        this.manageRepos = new Link(this.pageComposite, 72);
        this.manageRepos.setText("Add more software by updating  <a>repository list</a>");
        this.manageRepos.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.manageRepos.moveAbove(null);
        this.manageRepos.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                SoftwareLandingPage.this.editRepositoriesList();
            }
        });
        Composite description = new Composite(this.pageComposite, 0);
        GridData gd = AdminUiUtil.createFillData();
        gd.verticalIndent = 10;
        description.setLayoutData((Object)gd);
        description.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin((int)2, (boolean)false));
        this.packagesViewer = new ListViewer(description, 2820);
        List list = this.packagesViewer.getList();
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.packagesViewer.setContentProvider((IContentProvider)new PackageContentProvider());
        this.packagesViewer.setLabelProvider((IBaseLabelProvider)new P2UiLabelProvider());
        this.packagesViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SoftwareLandingPage.this.editSelectedPackage();
            }
        });
        Composite buttons = new Composite(description, 0);
        buttons.setLayoutData((Object)new GridData(1, 4, false, true));
        buttons.setLayout((Layout)new GridLayout());
        this.createButtons(buttons);
        this.updateButtons();
        return this.pageComposite;
    }

    public void deactivate() {
        super.deactivate();
        if (this.packagesViewer != null) {
            if (this.updateButtonsListener != null) {
                this.packagesViewer.removeSelectionChangedListener(this.updateButtonsListener);
                this.updateButtonsListener = null;
            }
            if (!this.packagesViewer.getList().isDisposed()) {
                this.packagesViewer.setInput(null);
            }
        }
    }

    void editRepositoriesList() {
        final RepositoriesListDialog dialog = new RepositoriesListDialog(SwtUtil.getShell((Widget)this.manageRepos), this.getRepoManager());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                dialog.deactivate();
            }
        });
    }

    void editSelectedPackage() {
        EditPackageDialog dialog = new EditPackageDialog(SwtUtil.getShell((Widget)this.addButton), this.getPackageManager(), this.getSelectedPackage());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    SoftwareLandingPage.this.refresh();
                }
            }
        });
    }

    IPackageManager getPackageManager() {
        return P2Activator.getInstance().getPackageManager();
    }

    private IRepositoryDefinitionManager getRepoManager() {
        return P2Activator.getInstance().getRepositoryManager();
    }

    private PackageDefinition getSelectedPackage() {
        StructuredSelection selection = (StructuredSelection)this.packagesViewer.getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof PackageDefinition) {
            return (PackageDefinition)selection.getFirstElement();
        }
        return null;
    }

    void provisionButtonPressed() {
        PackageDefinition pkg = this.getSelectedPackage();
        if (pkg == null) {
            return;
        }
        this.getPackageManager().markedForInstall(pkg);
        this.refresh();
    }

    void refresh() {
        this.packagesViewer.refresh();
    }

    void removeButtonPressed() {
        final PackageDefinition pkg = this.getSelectedPackage();
        if (pkg == null) {
            return;
        }
        NonBlockingMessageDialogs.openQuestion((Shell)SwtUtil.getShell((Widget)this.removeButton), (String)"Remove Package", (String)"Do you really want to delete the package?", (DialogCallback)new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    SoftwareLandingPage.this.getPackageManager().removePackage(pkg.getId());
                    SoftwareLandingPage.this.refresh();
                }
            }
        });
    }

    void revokeButtonPressed() {
        PackageDefinition pkg = this.getSelectedPackage();
        if (pkg == null) {
            return;
        }
        this.getPackageManager().markedForUninstall(pkg);
        this.refresh();
    }

    void updateButtons() {
        int selectedElementsCount = ((IStructuredSelection)this.packagesViewer.getSelection()).size();
        if (selectedElementsCount == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.provisionButton.setEnabled(false);
            this.revokeButton.setEnabled(false);
            return;
        }
        boolean markedforInstall = false;
        boolean markedforUninstall = false;
        if ((markedforInstall |= this.getPackageManager().isMarkedForInstall(this.getSelectedPackage())) && (markedforUninstall |= !this.getPackageManager().isMarkedForInstall(this.getSelectedPackage()))) {
            return;
        }
        this.provisionButton.setEnabled(markedforUninstall);
        this.revokeButton.setEnabled(markedforInstall);
        this.removeButton.setEnabled(markedforUninstall);
        this.editButton.setEnabled(selectedElementsCount == 1);
    }
}

