/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.connectors;

import java.security.KeyStore;
import org.eclipse.gyrex.http.jetty.admin.ICertificate;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class CertificateSslContextFactory
extends SslContextFactory {
    private final ICertificate certificate;

    public CertificateSslContextFactory(ICertificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate must not be null");
        }
        this.certificate = certificate;
        this.setTrustAll(false);
        this.setKeyStorePath("Gyrex-Certificat:" + certificate.getId());
        this.setKeyManagerPassword(new String(certificate.getKeyPassword()));
    }

    public void checkKeyStore() {
    }

    protected KeyStore loadKeyStore() throws Exception {
        return this.certificate.getKeyStore();
    }

    protected KeyStore loadTrustStore() throws Exception {
        return this.certificate.getKeyStore();
    }
}

