/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal.commonapenders;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.admin.ui.logback.configuration.wizard.AppenderConfigurationWizardSession;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.logback.config.model.FileAppender;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class FileAppenderWizardPage
extends WizardPage {
    private static final long serialVersionUID = 1L;
    private final StringDialogField fileNameField = new StringDialogField();
    private final SelectionButtonDialogField compressField = new SelectionButtonDialogField(32);
    private final SelectionButtonDialogFieldGroup rotationTypeField = new SelectionButtonDialogFieldGroup(16, new String[]{"never", "daily", "weekly", "monthly", "based on size"}, 5);
    private final StringDialogField maxFileSizeField = new StringDialogField();
    private final StringDialogField maxHistoryField = new StringDialogField();
    private final StringDialogField siftingPropertyNameField = new StringDialogField();
    private final StringDialogField siftingPropertyDefaultField = new StringDialogField();
    private final FileAppender appender;

    public FileAppenderWizardPage(AppenderConfigurationWizardSession session) {
        super("file");
        this.setTitle("File Appender");
        this.setDescription("Configure log file details like name and rotation.");
        this.appender = (FileAppender)Preconditions.checkNotNull((Object)session.getAppender());
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(this.convertVerticalDLUsToPixels(200), this.convertHorizontalDLUsToPixels(400)).create());
        this.setControl((Control)composite);
        this.fileNameField.setLabelText("File Name:");
        this.rotationTypeField.setLabelText("Rotate log files:");
        this.compressField.setLabelText("Compress rotated logs");
        this.maxHistoryField.setLabelText("Number of rotated logs to keep:");
        this.maxFileSizeField.setLabelText("Rotate when log file is greater then:");
        this.siftingPropertyNameField.setLabelText("Separate log files based on MDC property:");
        this.siftingPropertyDefaultField.setLabelText("Default value if MDC property is not set:");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                FileAppenderWizardPage.this.updateEnabledFields();
                FileAppenderWizardPage.this.validate();
            }
        };
        this.fileNameField.setDialogFieldListener(validateListener);
        this.rotationTypeField.setDialogFieldListener(validateListener);
        this.maxFileSizeField.setDialogFieldListener(validateListener);
        this.maxHistoryField.setDialogFieldListener(validateListener);
        this.siftingPropertyNameField.setDialogFieldListener(validateListener);
        this.compressField.setSelection(true);
        this.updateEnabledFields();
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.fileNameField, new Separator(), this.rotationTypeField, this.compressField, this.maxHistoryField, this.maxFileSizeField, new Separator(), this.siftingPropertyNameField, this.siftingPropertyDefaultField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.fileNameField.getTextControl(null));
    }

    private void updateAppender() {
        this.appender.setFileName(this.fileNameField.getText());
        if (this.rotationTypeField.isSelected(1) || this.rotationTypeField.isSelected(2) || this.rotationTypeField.isSelected(3)) {
            if (this.rotationTypeField.isSelected(1)) {
                this.appender.setRotationPolicy(FileAppender.RotationPolicy.DAILY);
            } else if (this.rotationTypeField.isSelected(2)) {
                this.appender.setRotationPolicy(FileAppender.RotationPolicy.WEEKLY);
            } else if (this.rotationTypeField.isSelected(3)) {
                this.appender.setRotationPolicy(FileAppender.RotationPolicy.MONTHLY);
            }
            this.appender.setMaxHistory(StringUtils.trimToNull((String)this.maxHistoryField.getText()));
        } else if (this.rotationTypeField.isSelected(4)) {
            this.appender.setRotationPolicy(FileAppender.RotationPolicy.SIZE);
            this.appender.setMaxFileSize(StringUtils.trimToNull((String)this.maxFileSizeField.getText()));
        }
        this.appender.setCompressRotatedLogs(this.compressField.isSelected());
        String siftingMdcPropertyName = StringUtils.trimToNull((String)this.siftingPropertyNameField.getText());
        if (siftingMdcPropertyName != null) {
            this.appender.setSiftingMdcPropertyName(siftingMdcPropertyName);
            this.appender.setSiftingMdcPropertyDefaultValue(StringUtils.trimToNull((String)this.siftingPropertyDefaultField.getText()));
        }
    }

    void updateEnabledFields() {
        this.siftingPropertyDefaultField.setEnabled(StringUtils.isNotBlank((String)this.siftingPropertyNameField.getText()));
        if (this.rotationTypeField.isSelected(1) || this.rotationTypeField.isSelected(2) || this.rotationTypeField.isSelected(3)) {
            this.maxFileSizeField.setEnabled(false);
            this.maxHistoryField.setEnabled(true);
            this.compressField.setEnabled(true);
        } else if (this.rotationTypeField.isSelected(4)) {
            this.maxFileSizeField.setEnabled(true);
            this.maxHistoryField.setEnabled(false);
            this.compressField.setEnabled(true);
        } else {
            this.maxFileSizeField.setEnabled(false);
            this.maxHistoryField.setEnabled(false);
            this.compressField.setEnabled(false);
        }
    }

    void validate() {
        String fileName = this.fileNameField.getText();
        if (StringUtils.isBlank((String)fileName)) {
            this.setMessage("Please enter a file name.", 1);
            this.setPageComplete(false);
            return;
        }
        if (!IdHelper.isValidId((String)fileName)) {
            this.setMessage("The entered file name is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.", 3);
            return;
        }
        this.updateAppender();
        this.setMessage(null);
        this.setPageComplete(true);
    }
}

