/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.rap.application;

import com.google.common.base.Preconditions;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.rap.application.Category;
import org.eclipse.gyrex.rap.application.Page;
import org.eclipse.gyrex.rap.application.PageHandle;
import org.eclipse.gyrex.rap.application.PageProvider;

public class InjectingPageProvider
extends PageProvider {
    private final IRuntimeContext context;

    public InjectingPageProvider(IRuntimeContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context must not be null");
        this.context = context;
    }

    @Override
    public Page createPage(PageHandle pageHandle) throws Exception {
        return (Page)this.context.getInjector().make(((PageHandleWithClass)pageHandle).getPageClass());
    }

    public CategoryRegistrationBuilder newCategory(String id) {
        return new CategoryRegistrationBuilder(id);
    }

    public PageRegistrationBuilder newPage(String id) {
        return new PageRegistrationBuilder(id);
    }

    public class CategoryRegistrationBuilder {
        private final String id;
        private String name;
        private String sortKey;

        public CategoryRegistrationBuilder(String id) {
            this.id = id;
        }

        public CategoryRegistrationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public void register() {
            Category category = new Category(this.id);
            category.setName(this.name);
            category.setSortKey(this.sortKey);
            InjectingPageProvider.this.addCategory(category);
        }

        public CategoryRegistrationBuilder sortKey(String sortKey) {
            this.sortKey = sortKey;
            return this;
        }
    }

    class PageHandleWithClass
    extends PageHandle {
        private final Class<? extends Page> pageClass;

        public PageHandleWithClass(String id, Class<? extends Page> pageClass) {
            super(id);
            this.pageClass = pageClass;
        }

        Class<? extends Page> getPageClass() {
            return this.pageClass;
        }
    }

    public class PageRegistrationBuilder {
        private final String id;
        private String name;
        private String sortKey;
        private String categoryId;
        private Class<? extends Page> pageClass;

        public PageRegistrationBuilder(String id) {
            this.id = id;
        }

        public PageRegistrationBuilder categoryId(String categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public PageRegistrationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PageRegistrationBuilder pageClass(Class<? extends Page> pageClass) {
            this.pageClass = pageClass;
            return this;
        }

        public void register() {
            PageHandleWithClass handle = new PageHandleWithClass(this.id, this.pageClass);
            handle.setName(this.name);
            handle.setSortKey(this.sortKey);
            handle.setCategoryId(this.categoryId);
            InjectingPageProvider.this.addPage(handle);
        }

        public PageRegistrationBuilder sortKey(String sortKey) {
            this.sortKey = sortKey;
            return this;
        }
    }
}

