/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.p2.internal;

import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingStatusDialog;
import org.eclipse.gyrex.admin.ui.p2.internal.EditRepositoryDialog;
import org.eclipse.gyrex.admin.ui.p2.internal.P2UiLabelProvider;
import org.eclipse.gyrex.admin.ui.p2.internal.RepositoryContentProvider;
import org.eclipse.gyrex.p2.internal.repositories.IRepositoryDefinitionManager;
import org.eclipse.gyrex.p2.internal.repositories.RepositoryDefinition;
import org.eclipse.gyrex.rap.helper.SwtUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class RepositoriesListDialog
extends NonBlockingStatusDialog {
    private static final long serialVersionUID = 1L;
    private ListViewer reposViewer;
    private Button addButton;
    private Button removeButton;
    private Button editButton;
    private ISelectionChangedListener updateButtonsListener;
    private final IRepositoryDefinitionManager repoManager;

    public RepositoriesListDialog(Shell parent, IRepositoryDefinitionManager repoManager) {
        super(parent);
        this.repoManager = repoManager;
        this.setTitle("Edit Repositorylist");
        this.setShellStyle(67696);
    }

    private void activate() {
        if (this.reposViewer != null) {
            this.reposViewer.setInput((Object)this.repoManager);
            this.updateButtonsListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    RepositoriesListDialog.this.updateButtons();
                }
            };
            this.reposViewer.addSelectionChangedListener(this.updateButtonsListener);
            this.reposViewer.getControl().getDisplay();
        }
    }

    private void addNewRepository() {
        EditRepositoryDialog dialog = new EditRepositoryDialog(this.getParentShell(), null, this.repoManager);
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    RepositoriesListDialog.this.refresh();
                }
            }
        });
    }

    private Button createButton(Composite buttons, String buttonLabel) {
        Button b = new Button(buttons, 0);
        b.setText(buttonLabel);
        b.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return b;
    }

    protected void createButtons(Composite buttonsPanel) {
        this.addButton = this.createButton(buttonsPanel, "Add...");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                RepositoriesListDialog.this.addNewRepository();
            }
        });
        this.removeButton = this.createButton(buttonsPanel, "Remove...");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                RepositoriesListDialog.this.removeRepository();
            }
        });
        this.editButton = this.createButton(buttonsPanel, "Edit...");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                RepositoriesListDialog.this.editSelectedRepository();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        composite.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin((int)2, (boolean)false));
        this.reposViewer = new ListViewer(composite, 2820);
        List list = this.reposViewer.getList();
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.reposViewer.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.reposViewer.setLabelProvider((IBaseLabelProvider)new P2UiLabelProvider());
        this.reposViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                RepositoriesListDialog.this.editSelectedRepository();
            }
        });
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(1, 4, false, true));
        buttons.setLayout((Layout)new GridLayout());
        this.createButtons(buttons);
        this.updateButtons();
        this.activate();
        return composite;
    }

    public void deactivate() {
        if (this.reposViewer != null) {
            if (this.updateButtonsListener != null) {
                this.reposViewer.removeSelectionChangedListener(this.updateButtonsListener);
                this.updateButtonsListener = null;
            }
            if (!this.reposViewer.getList().isDisposed()) {
                this.reposViewer.setInput(null);
            }
        }
    }

    private void editSelectedRepository() {
        EditRepositoryDialog dialog = new EditRepositoryDialog(this.getParentShell(), this.getSelectedRepo(), this.repoManager);
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    RepositoriesListDialog.this.refresh();
                }
            }
        });
    }

    private RepositoryDefinition getSelectedRepo() {
        StructuredSelection selection = (StructuredSelection)this.reposViewer.getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof RepositoryDefinition) {
            return (RepositoryDefinition)selection.getFirstElement();
        }
        return null;
    }

    public void refresh() {
        this.reposViewer.refresh();
    }

    void removeRepository() {
        final RepositoryDefinition repo = this.getSelectedRepo();
        if (repo == null) {
            return;
        }
        NonBlockingMessageDialogs.openQuestion((Shell)SwtUtil.getShell((Widget)this.removeButton), (String)"Remove Repository", (String)"Do you really want to delete the repository?", (DialogCallback)new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    RepositoriesListDialog.this.repoManager.removeRepository(repo.getId());
                    RepositoriesListDialog.this.refresh();
                }
            }
        });
    }

    protected void updateButtons() {
        int selectedElementsCount = ((IStructuredSelection)this.reposViewer.getSelection()).size();
        if (selectedElementsCount == 0) {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        }
    }
}

