/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ActivityComparator;
import org.sat4j.minisat.core.ConflictTimer;
import org.sat4j.minisat.core.ConflictTimerAdapter;
import org.sat4j.minisat.core.ConflictTimerContainer;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.Counter;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ICDCL;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.ISimplifier;
import org.sat4j.minisat.core.LearnedConstraintsDeletionStrategy;
import org.sat4j.minisat.core.LearnedConstraintsEvaluationType;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Pair;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SimplificationType;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.VoidTracing;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.Lbool;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.specs.UnitClauseProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solver<D extends DataStructureFactory>
implements ISolverService,
ICDCL<D> {
    private static final long serialVersionUID = 1L;
    private static final double CLAUSE_RESCALE_FACTOR = 1.0E-20;
    private static final double CLAUSE_RESCALE_BOUND = 1.0E20;
    protected ILogAble out;
    protected final IVec<Constr> constrs = new Vec<Constr>();
    protected final IVec<Constr> learnts = new Vec<Constr>();
    private double claInc = 1.0;
    private double claDecay = 1.0;
    private int qhead = 0;
    protected final IVecInt trail = new VecInt();
    protected final IVecInt trailLim = new VecInt();
    protected int rootLevel;
    private int[] model = null;
    protected ILits voc;
    private IOrder order;
    private final ActivityComparator comparator = new ActivityComparator();
    private SolverStats stats = new SolverStats();
    private LearningStrategy<D> learner;
    protected volatile boolean undertimeout;
    private long timeout = Integer.MAX_VALUE;
    private boolean timeBasedTimeout = true;
    protected D dsfactory;
    private SearchParams params;
    private final IVecInt __dimacs_out = new VecInt();
    protected SearchListener slistener = new VoidTracing();
    private RestartStrategy restarter;
    private final Map<String, Counter> constrTypes = new HashMap<String, Counter>();
    private boolean isDBSimplificationAllowed = false;
    private final IVecInt learnedLiterals = new VecInt();
    private boolean verbose = false;
    private boolean keepHot = false;
    private String prefix = "c ";
    private int declaredMaxVarId = 0;
    private UnitClauseProvider unitClauseProvider = UnitClauseProvider.VOID;
    private boolean[] mseen = new boolean[0];
    private final IVecInt mpreason = new VecInt();
    private final IVecInt moutLearnt = new VecInt();
    public static final ISimplifier NO_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt outLearnt) {
        }

        public String toString() {
            return "No reason simplification";
        }
    };
    public final ISimplifier SIMPLE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt conflictToReduce) {
            Solver.this.simpleSimplification(conflictToReduce);
        }

        public String toString() {
            return "Simple reason simplification";
        }
    };
    public final ISimplifier EXPENSIVE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt conflictToReduce) {
            Solver.this.expensiveSimplification(conflictToReduce);
        }

        public String toString() {
            return "Expensive reason simplification";
        }
    };
    public final ISimplifier EXPENSIVE_SIMPLIFICATION_WLONLY = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt conflictToReduce) {
            Solver.this.expensiveSimplificationWLOnly(conflictToReduce);
        }

        public String toString() {
            return "Expensive reason simplification specific for WL data structure";
        }
    };
    private ISimplifier simplifier = NO_SIMPLIFICATION;
    private final IVecInt analyzetoclear = new VecInt();
    private final IVecInt analyzestack = new VecInt();
    private final IVec<Propagatable> watched = new Vec<Propagatable>();
    private final Pair analysisResult = new Pair();
    private boolean[] userbooleanmodel;
    private IVecInt unsatExplanationInTermsOfAssumptions;
    private final IVecInt implied = new VecInt();
    private final IVecInt decisions = new VecInt();
    private int[] fullmodel;
    private int[] prime;
    private double timebegin = 0.0;
    private boolean needToReduceDB;
    private ConflictTimerContainer conflictCount;
    private transient Timer timer;
    private final ConflictTimer memoryTimer = new ConflictTimerAdapter(500){
        private static final long serialVersionUID = 1L;
        final long memorybound;
        {
            this.memorybound = Runtime.getRuntime().freeMemory() / 10L;
        }

        public void run() {
            long freemem = Runtime.getRuntime().freeMemory();
            if (freemem < this.memorybound) {
                Solver.this.needToReduceDB = true;
            }
        }
    };
    public final LearnedConstraintsDeletionStrategy memory_based = this.activityBased(this.memoryTimer);
    private final ConflictTimer lbdTimer = new ConflictTimerAdapter(1000){
        private static final long serialVersionUID = 1L;
        private int nbconflict;
        private static final int MAX_CLAUSE = 5000;
        private static final int INC_CLAUSE = 1000;
        private int nextbound;
        {
            this.nbconflict = 0;
            this.nextbound = 5000;
        }

        public void run() {
            this.nbconflict += this.bound();
            if (this.nbconflict >= this.nextbound) {
                this.nextbound += 1000;
                this.nbconflict = 0;
                Solver.this.needToReduceDB = true;
            }
        }

        public void reset() {
            super.reset();
            this.nextbound = 5000;
            if (this.nbconflict >= this.nextbound) {
                this.nbconflict = 0;
                Solver.this.needToReduceDB = true;
            }
        }
    };
    public final LearnedConstraintsDeletionStrategy glucose;
    protected LearnedConstraintsDeletionStrategy learnedConstraintsDeletionStrategy = this.glucose = new Glucose2LCDS(this.lbdTimer);
    private boolean lastConflictMeansUnsat;
    protected Constr sharedConflict;
    private final Comparator<Integer> dimacsLevel = new Comparator<Integer>(){

        @Override
        public int compare(Integer i1, Integer i2) {
            return Solver.this.voc.getLevel(Math.abs(i2)) - Solver.this.voc.getLevel(Math.abs(i1));
        }
    };

    protected IVecInt dimacs2internal(IVecInt in) {
        this.__dimacs_out.clear();
        this.__dimacs_out.ensure(in.size());
        int i = 0;
        while (i < in.size()) {
            int p = in.get(i);
            if (p == 0) {
                throw new IllegalArgumentException("0 is not a valid variable identifier");
            }
            this.__dimacs_out.unsafePush(this.voc.getFromPool(p));
            ++i;
        }
        return this.__dimacs_out;
    }

    @Override
    public void registerLiteral(int p) {
        this.voc.getFromPool(p);
    }

    public Solver(LearningStrategy<D> learner, D dsf, IOrder order, RestartStrategy restarter) {
        this(learner, dsf, new SearchParams(), order, restarter);
    }

    public Solver(LearningStrategy<D> learner, D dsf, SearchParams params, IOrder order, RestartStrategy restarter) {
        this(learner, dsf, params, order, restarter, ILogAble.CONSOLE);
    }

    public Solver(LearningStrategy<D> learner, D dsf, SearchParams params, IOrder order, RestartStrategy restarter, ILogAble logger) {
        this.order = order;
        this.params = params;
        this.restarter = restarter;
        this.out = logger;
        this.setDataStructureFactory(dsf);
        this.setLearningStrategy(learner);
    }

    @Override
    public final void setDataStructureFactory(D dsf) {
        this.dsfactory = dsf;
        this.dsfactory.setUnitPropagationListener(this);
        this.dsfactory.setLearner(this);
        this.voc = dsf.getVocabulary();
        this.order.setLits(this.voc);
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    @Override
    public <S extends ISolverService> void setSearchListener(SearchListener<S> sl) {
        this.slistener = sl;
    }

    @Override
    public <S extends ISolverService> SearchListener<S> getSearchListener() {
        return this.slistener;
    }

    @Override
    public void setLearner(LearningStrategy<D> strategy) {
        this.setLearningStrategy(strategy);
    }

    @Override
    public void setLearningStrategy(LearningStrategy<D> strategy) {
        if (this.learner != null) {
            this.learner.setSolver(null);
        }
        this.learner = strategy;
        strategy.setSolver(this);
    }

    @Override
    public void setTimeout(int t) {
        this.timeout = (long)t * 1000L;
        this.timeBasedTimeout = true;
    }

    @Override
    public void setTimeoutMs(long t) {
        this.timeout = t;
        this.timeBasedTimeout = true;
    }

    @Override
    public void setTimeoutOnConflicts(int count) {
        this.timeout = count;
        this.timeBasedTimeout = false;
    }

    @Override
    public void setSearchParams(SearchParams sp) {
        this.params = sp;
    }

    @Override
    public SearchParams getSearchParams() {
        return this.params;
    }

    @Override
    public void setRestartStrategy(RestartStrategy restarter) {
        this.restarter = restarter;
    }

    @Override
    public RestartStrategy getRestartStrategy() {
        return this.restarter;
    }

    @Override
    public void expireTimeout() {
        this.undertimeout = false;
        if (this.timeBasedTimeout) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        } else if (this.conflictCount != null) {
            this.conflictCount = null;
        }
    }

    protected int nAssigns() {
        return this.trail.size();
    }

    @Override
    public int nConstraints() {
        return this.constrs.size();
    }

    @Override
    public void learn(Constr c) {
        this.slistener.learn(c);
        this.learnts.push(c);
        c.setLearnt();
        c.register();
        ++this.stats.learnedclauses;
        switch (c.size()) {
            case 2: {
                ++this.stats.learnedbinaryclauses;
                break;
            }
            case 3: {
                ++this.stats.learnedternaryclauses;
            }
        }
    }

    public final int decisionLevel() {
        return this.trailLim.size();
    }

    @Override
    @Deprecated
    public int newVar() {
        int index = this.voc.nVars() + 1;
        this.voc.ensurePool(index);
        return index;
    }

    @Override
    public int newVar(int howmany) {
        this.voc.ensurePool(howmany);
        this.declaredMaxVarId = howmany;
        return howmany;
    }

    @Override
    public IConstr addClause(IVecInt literals) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        return this.addConstr(this.dsfactory.createClause(vlits));
    }

    @Override
    public boolean removeConstr(IConstr co) {
        if (co == null) {
            throw new IllegalArgumentException("Reference to the constraint to remove needed!");
        }
        Constr c = (Constr)co;
        c.remove(this);
        this.constrs.remove(c);
        this.clearLearntClauses();
        String type = c.getClass().getName();
        this.constrTypes.get(type).dec();
        return true;
    }

    @Override
    public boolean removeSubsumedConstr(IConstr co) {
        if (co == null) {
            throw new IllegalArgumentException("Reference to the constraint to remove needed!");
        }
        if (this.constrs.last() != co) {
            throw new IllegalArgumentException("Can only remove latest added constraint!!!");
        }
        Constr c = (Constr)co;
        c.remove(this);
        this.constrs.pop();
        String type = c.getClass().getName();
        this.constrTypes.get(type).dec();
        return true;
    }

    @Override
    public void addAllClauses(IVec<IVecInt> clauses) throws ContradictionException {
        Iterator<IVecInt> iterator = clauses.iterator();
        while (iterator.hasNext()) {
            this.addClause(iterator.next());
        }
    }

    @Override
    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        int n = literals.size();
        VecInt opliterals = new VecInt(n);
        IteratorInt iterator = literals.iterator();
        while (iterator.hasNext()) {
            opliterals.push(-iterator.next());
        }
        return this.addAtLeast(opliterals, n - degree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        IVecInt vlits = this.dimacs2internal(literals);
        return this.addConstr(this.dsfactory.createCardinalityConstraint(vlits, degree));
    }

    @Override
    public IConstr addExactly(IVecInt literals, int n) throws ContradictionException {
        ConstrGroup group = new ConstrGroup(false);
        group.add(this.addAtMost(literals, n));
        group.add(this.addAtLeast(literals, n));
        return group;
    }

    public boolean simplifyDB() {
        IVec[] cs = new IVec[]{this.constrs, this.learnts};
        int type = 0;
        while (type < 2) {
            int j = 0;
            int i = 0;
            while (i < cs[type].size()) {
                if (((Constr)cs[type].get(i)).simplify()) {
                    ((Constr)cs[type].get(i)).remove(this);
                } else {
                    cs[type].moveTo(j++, i);
                }
                ++i;
            }
            cs[type].shrinkTo(j);
            ++type;
        }
        return true;
    }

    @Override
    public int[] model() {
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        int[] nmodel = new int[this.model.length];
        System.arraycopy(this.model, 0, nmodel, 0, this.model.length);
        return nmodel;
    }

    @Override
    public boolean enqueue(int p) {
        return this.enqueue(p, null);
    }

    @Override
    public boolean enqueue(int p, Constr from) {
        assert (p > 1);
        if (this.voc.isSatisfied(p)) {
            return true;
        }
        if (this.voc.isFalsified(p)) {
            return false;
        }
        this.voc.satisfies(p);
        this.voc.setLevel(p, this.decisionLevel());
        this.voc.setReason(p, from);
        this.trail.push(p);
        if (from != null && from.learnt()) {
            this.learnedConstraintsDeletionStrategy.onPropagation(from);
        }
        return true;
    }

    public void analyze(Constr confl, Pair results) throws TimeoutException {
        assert (confl != null);
        boolean[] seen = this.mseen;
        IVecInt outLearnt = this.moutLearnt;
        IVecInt preason = this.mpreason;
        outLearnt.clear();
        assert (outLearnt.size() == 0);
        int i = 0;
        while (i < seen.length) {
            seen[i] = false;
            ++i;
        }
        int counter = 0;
        int p = -1;
        outLearnt.push(-1);
        int outBtlevel = 0;
        Constr prevConfl = null;
        do {
            preason.clear();
            assert (confl != null);
            if (prevConfl != confl) {
                confl.calcReason(p, preason);
                this.learnedConstraintsDeletionStrategy.onConflictAnalysis(confl);
                int j = 0;
                while (j < preason.size()) {
                    int q = preason.get(j);
                    this.order.updateVar(q);
                    if (!seen[q >> 1]) {
                        seen[q >> 1] = true;
                        if (this.voc.getLevel(q) == this.decisionLevel()) {
                            ++counter;
                            this.order.updateVarAtDecisionLevel(q);
                        } else if (this.voc.getLevel(q) > 0) {
                            outLearnt.push(q ^ 1);
                            outBtlevel = Math.max(outBtlevel, this.voc.getLevel(q));
                        }
                    }
                    ++j;
                }
            }
            prevConfl = confl;
            do {
                p = this.trail.last();
                confl = this.voc.getReason(p);
                this.undoOne();
            } while (!seen[p >> 1]);
        } while (--counter > 0);
        outLearnt.set(0, p ^ 1);
        this.simplifier.simplify(outLearnt);
        Constr c = this.dsfactory.createUnregisteredClause(outLearnt);
        this.learnedConstraintsDeletionStrategy.onClauseLearning(c);
        results.reason = c;
        assert (outBtlevel > -1);
        results.backtrackLevel = outBtlevel;
    }

    /*
     * Unable to fully structure code
     */
    public IVecInt analyzeFinalConflictInTermsOfAssumptions(Constr confl, IVecInt assumps, int conflictingLiteral) {
        if (assumps.size() != 0) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            this.trailLim.pop();
lbl5:
            // 2 sources

            ** while (!this.trailLim.isEmpty() && this.trailLim.last() == this.trail.size())
        }
lbl6:
        // 1 sources

        seen = this.mseen;
        outLearnt = this.moutLearnt;
        preason = this.mpreason;
        outLearnt.clear();
        if (this.trailLim.size() == 0) {
            return outLearnt;
        }
        if (!Solver.$assertionsDisabled && outLearnt.size() != 0) {
            throw new AssertionError();
        }
        i = 0;
        while (i < seen.length) {
            seen[i] = false;
            ++i;
        }
        if (confl == null) {
            seen[conflictingLiteral >> 1] = true;
        }
        p = -1;
        while (confl == null && this.trail.size() > 0 && this.trailLim.size() > 0) {
            p = this.trail.last();
            confl = this.voc.getReason(p);
            this.undoOne();
            if (confl == null && p == (conflictingLiteral ^ 1)) {
                outLearnt.push(LiteralsUtils.toDimacs(p));
            }
            if (this.trail.size() > this.trailLim.last()) continue;
            this.trailLim.pop();
        }
        if (confl == null) {
            return outLearnt;
        }
        do {
            preason.clear();
            confl.calcReason(p, preason);
            j = 0;
            while (j < preason.size()) {
                q = preason.get(j);
                if (!seen[q >> 1]) {
                    seen[q >> 1] = true;
                    if (this.voc.getReason(q) == null && this.voc.getLevel(q) > 0) {
                        if (!Solver.$assertionsDisabled && !assumps.contains(LiteralsUtils.toDimacs(q))) {
                            throw new AssertionError();
                        }
                        outLearnt.push(LiteralsUtils.toDimacs(q));
                    }
                }
                ++j;
            }
            do {
                p = this.trail.last();
                confl = this.voc.getReason(p);
                this.undoOne();
                if (this.decisionLevel() <= 0 || this.trail.size() > this.trailLim.last()) continue;
                this.trailLim.pop();
            } while (this.trail.size() > 0 && this.decisionLevel() > 0 && (!seen[p >> 1] || confl == null));
        } while (this.decisionLevel() > 0);
        return outLearnt;
    }

    @Override
    public void setSimplifier(SimplificationType simp) {
        try {
            Field f = Solver.class.getDeclaredField(simp.toString());
            this.simplifier = (ISimplifier)f.get(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.simplifier = NO_SIMPLIFICATION;
        }
    }

    @Override
    public void setSimplifier(ISimplifier simp) {
        this.simplifier = simp;
    }

    @Override
    public ISimplifier getSimplifier() {
        return this.simplifier;
    }

    private void simpleSimplification(IVecInt conflictToReduce) {
        boolean[] seen = this.mseen;
        int j = 1;
        int i = 1;
        while (i < conflictToReduce.size()) {
            Constr r = this.voc.getReason(conflictToReduce.get(i));
            if (r == null || r.canBePropagatedMultipleTimes()) {
                conflictToReduce.moveTo(j++, i);
            } else {
                int k = 0;
                while (k < r.size()) {
                    int p = r.get(k);
                    if (!seen[p >> 1] && this.voc.isFalsified(p) && this.voc.getLevel(p) != 0) {
                        conflictToReduce.moveTo(j++, i);
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        conflictToReduce.shrink(i - j);
        this.stats.reducedliterals += (long)(i - j);
    }

    private void expensiveSimplification(IVecInt conflictToReduce) {
        this.analyzetoclear.clear();
        conflictToReduce.copyTo(this.analyzetoclear);
        int i = 1;
        int j = 1;
        while (i < conflictToReduce.size()) {
            if (this.voc.getReason(conflictToReduce.get(i)) == null || !this.analyzeRemovable(conflictToReduce.get(i))) {
                conflictToReduce.moveTo(j++, i);
            }
            ++i;
        }
        conflictToReduce.shrink(i - j);
        this.stats.reducedliterals += (long)(i - j);
    }

    private boolean analyzeRemovable(int p) {
        assert (this.voc.getReason(p) != null);
        ILits lvoc = this.voc;
        IVecInt lanalyzestack = this.analyzestack;
        IVecInt lanalyzetoclear = this.analyzetoclear;
        lanalyzestack.clear();
        lanalyzestack.push(p);
        boolean[] seen = this.mseen;
        int top = lanalyzetoclear.size();
        while (lanalyzestack.size() > 0) {
            int q = lanalyzestack.last();
            assert (lvoc.getReason(q) != null);
            Constr c = lvoc.getReason(q);
            lanalyzestack.pop();
            if (c.canBePropagatedMultipleTimes()) {
                int j = top;
                while (j < lanalyzetoclear.size()) {
                    seen[lanalyzetoclear.get((int)j) >> 1] = false;
                    ++j;
                }
                lanalyzetoclear.shrink(lanalyzetoclear.size() - top);
                return false;
            }
            int i = 0;
            while (i < c.size()) {
                int l = c.get(i);
                if (!seen[LiteralsUtils.var(l)] && lvoc.isFalsified(l) && lvoc.getLevel(l) != 0) {
                    if (lvoc.getReason(l) == null) {
                        int j = top;
                        while (j < lanalyzetoclear.size()) {
                            seen[lanalyzetoclear.get((int)j) >> 1] = false;
                            ++j;
                        }
                        lanalyzetoclear.shrink(lanalyzetoclear.size() - top);
                        return false;
                    }
                    seen[l >> 1] = true;
                    lanalyzestack.push(l);
                    lanalyzetoclear.push(l);
                }
                ++i;
            }
        }
        return true;
    }

    private void expensiveSimplificationWLOnly(IVecInt conflictToReduce) {
        this.analyzetoclear.clear();
        conflictToReduce.copyTo(this.analyzetoclear);
        int i = 1;
        int j = 1;
        while (i < conflictToReduce.size()) {
            if (this.voc.getReason(conflictToReduce.get(i)) == null || !this.analyzeRemovableWLOnly(conflictToReduce.get(i))) {
                conflictToReduce.moveTo(j++, i);
            }
            ++i;
        }
        conflictToReduce.shrink(i - j);
        this.stats.reducedliterals += (long)(i - j);
    }

    private boolean analyzeRemovableWLOnly(int p) {
        assert (this.voc.getReason(p) != null);
        this.analyzestack.clear();
        this.analyzestack.push(p);
        boolean[] seen = this.mseen;
        int top = this.analyzetoclear.size();
        while (this.analyzestack.size() > 0) {
            int q = this.analyzestack.last();
            assert (this.voc.getReason(q) != null);
            Constr c = this.voc.getReason(q);
            this.analyzestack.pop();
            int i = 1;
            while (i < c.size()) {
                int l = c.get(i);
                if (!seen[LiteralsUtils.var(l)] && this.voc.getLevel(l) != 0) {
                    if (this.voc.getReason(l) == null) {
                        int j = top;
                        while (j < this.analyzetoclear.size()) {
                            seen[this.analyzetoclear.get((int)j) >> 1] = false;
                            ++j;
                        }
                        this.analyzetoclear.shrink(this.analyzetoclear.size() - top);
                        return false;
                    }
                    seen[l >> 1] = true;
                    this.analyzestack.push(l);
                    this.analyzetoclear.push(l);
                }
                ++i;
            }
        }
        return true;
    }

    protected void undoOne() {
        int p = this.trail.last();
        assert (p > 1);
        assert (this.voc.getLevel(p) >= 0);
        int x = p >> 1;
        this.voc.unassign(p);
        this.voc.setReason(p, null);
        this.voc.setLevel(p, -1);
        this.order.undo(x);
        this.trail.pop();
        IVec<Undoable> undos = this.voc.undos(p);
        assert (undos != null);
        int size = undos.size();
        while (size > 0) {
            undos.last().undo(p);
            undos.pop();
            --size;
        }
    }

    @Override
    public void claBumpActivity(Constr confl) {
        confl.incActivity(this.claInc);
        if (confl.getActivity() > 1.0E20) {
            this.claRescalActivity();
        }
    }

    @Override
    public void varBumpActivity(int p) {
        this.order.updateVar(p);
    }

    private void claRescalActivity() {
        int i = 0;
        while (i < this.learnts.size()) {
            this.learnts.get(i).rescaleBy(1.0E-20);
            ++i;
        }
        this.claInc *= 1.0E-20;
    }

    public final Constr propagate() {
        IVecInt ltrail = this.trail;
        SolverStats lstats = this.stats;
        IOrder lorder = this.order;
        SearchListener lslistener = this.slistener;
        while (this.qhead < ltrail.size()) {
            ++lstats.propagations;
            int p = ltrail.get(this.qhead++);
            lslistener.propagating(LiteralsUtils.toDimacs(p), null);
            lorder.assignLiteral(p);
            Constr confl = this.reduceClausesForFalsifiedLiteral(p);
            if (confl == null) continue;
            return confl;
        }
        return null;
    }

    private Constr reduceClausesForFalsifiedLiteral(int p) {
        assert (p > 1);
        IVec<Propagatable> lwatched = this.watched;
        lwatched.clear();
        this.voc.watches(p).moveTo(lwatched);
        int size = lwatched.size();
        int i = 0;
        while (i < size) {
            ++this.stats.inspects;
            if (!lwatched.get(i).propagate(this, p)) {
                int sizew = lwatched.size();
                int j = i + 1;
                while (j < sizew) {
                    this.voc.watch(p, lwatched.get(j));
                    ++j;
                }
                this.qhead = this.trail.size();
                return lwatched.get(i).toConstraint();
            }
            ++i;
        }
        return null;
    }

    void record(Constr constr) {
        constr.assertConstraint(this);
        int p = LiteralsUtils.toDimacs(constr.get(0));
        this.slistener.adding(p);
        if (constr.size() == 1) {
            ++this.stats.learnedliterals;
            this.slistener.learnUnit(p);
        } else {
            this.learner.learns(constr);
        }
    }

    public boolean assume(int p) {
        assert (this.trail.size() == this.qhead);
        assert (!this.trailLim.contains(this.trail.size()));
        this.trailLim.push(this.trail.size());
        return this.enqueue(p);
    }

    private void cancel() {
        int decisionvar = this.trail.unsafeGet(this.trailLim.last());
        this.slistener.backtracking(LiteralsUtils.toDimacs(decisionvar));
        int c = this.trail.size() - this.trailLim.last();
        while (c > 0) {
            this.undoOne();
            --c;
        }
        this.trailLim.pop();
        this.qhead = this.trail.size();
    }

    private void cancelLearntLiterals(int learnedLiteralsLimit) {
        this.learnedLiterals.clear();
        while (this.trail.size() > learnedLiteralsLimit) {
            this.learnedLiterals.push(this.trail.last());
            this.undoOne();
        }
    }

    protected void cancelUntil(int level) {
        while (this.decisionLevel() > level) {
            this.cancel();
        }
    }

    Lbool search(IVecInt assumps) {
        assert (this.rootLevel == this.decisionLevel());
        ++this.stats.starts;
        this.order.setVarDecay(1.0 / this.params.getVarDecay());
        this.claDecay = 1.0 / this.params.getClaDecay();
        do {
            this.slistener.beginLoop();
            Constr confl = this.propagate();
            assert (this.trail.size() == this.qhead);
            if (confl == null) {
                if (this.decisionLevel() == 0 && this.isDBSimplificationAllowed) {
                    ++this.stats.rootSimplifications;
                    boolean ret = this.simplifyDB();
                    assert (ret);
                }
                assert (this.nAssigns() <= this.voc.realnVars());
                if (this.nAssigns() == this.voc.realnVars()) {
                    this.modelFound();
                    this.slistener.solutionFound(this.fullmodel != null ? this.fullmodel : this.model, this);
                    if (this.sharedConflict == null) {
                        this.cancelUntil(this.rootLevel);
                        return Lbool.TRUE;
                    }
                    confl = this.sharedConflict;
                } else {
                    if (this.restarter.shouldRestart()) {
                        this.cancelUntil(this.rootLevel);
                        return Lbool.UNDEFINED;
                    }
                    if (this.needToReduceDB) {
                        this.reduceDB();
                        this.needToReduceDB = false;
                    }
                    if (this.sharedConflict == null) {
                        ++this.stats.decisions;
                        int p = this.order.select();
                        if (p == -1) {
                            confl = this.preventTheSameDecisionsToBeMade();
                            this.lastConflictMeansUnsat = false;
                        } else {
                            assert (p > 1);
                            this.slistener.assuming(LiteralsUtils.toDimacs(p));
                            boolean ret = this.assume(p);
                            assert (ret);
                        }
                    } else {
                        confl = this.sharedConflict;
                    }
                }
            }
            if (confl == null) continue;
            ++this.stats.conflicts;
            this.slistener.conflictFound(confl, this.decisionLevel(), this.trail.size());
            this.conflictCount.newConflict();
            if (this.decisionLevel() == this.rootLevel) {
                if (this.lastConflictMeansUnsat) {
                    this.unsatExplanationInTermsOfAssumptions = this.analyzeFinalConflictInTermsOfAssumptions(confl, assumps, -1);
                    return Lbool.FALSE;
                }
                return Lbool.UNDEFINED;
            }
            int conflictTrailLevel = this.trail.size();
            try {
                this.analyze(confl, this.analysisResult);
            }
            catch (TimeoutException timeoutException) {
                return Lbool.UNDEFINED;
            }
            assert (this.analysisResult.backtrackLevel < this.decisionLevel());
            int backjumpLevel = Math.max(this.analysisResult.backtrackLevel, this.rootLevel);
            this.slistener.backjump(backjumpLevel);
            this.cancelUntil(backjumpLevel);
            if (backjumpLevel == this.rootLevel) {
                this.restarter.onBackjumpToRootLevel();
            }
            if (confl == this.sharedConflict) {
                this.sharedConflict.assertConstraintIfNeeded(this);
                this.sharedConflict = null;
            }
            assert (this.decisionLevel() >= this.rootLevel && this.decisionLevel() >= this.analysisResult.backtrackLevel);
            if (this.analysisResult.reason == null) {
                return Lbool.FALSE;
            }
            this.record(this.analysisResult.reason);
            this.restarter.newLearnedClause(this.analysisResult.reason, conflictTrailLevel);
            this.analysisResult.reason = null;
            this.decayActivities();
        } while (this.undertimeout);
        return Lbool.UNDEFINED;
    }

    private Constr preventTheSameDecisionsToBeMade() {
        VecInt clause = new VecInt(this.nVars());
        int i = this.trail.size() - 1;
        while (i >= this.rootLevel) {
            int p = this.trail.get(i);
            if (this.voc.getReason(p) == null) {
                clause.push(p ^ 1);
            }
            --i;
        }
        return this.dsfactory.createUnregisteredClause(clause);
    }

    protected void analyzeAtRootLevel(Constr conflict) {
    }

    void modelFound() {
        int p;
        VecInt tempmodel = new VecInt(this.nVars());
        this.userbooleanmodel = new boolean[this.realNumberOfVariables()];
        this.fullmodel = null;
        int i = 1;
        while (i <= this.nVars()) {
            if (this.voc.belongsToPool(i) && !this.voc.isUnassigned(p = this.voc.getFromPool(i))) {
                tempmodel.push(this.voc.isSatisfied(p) ? i : -i);
                this.userbooleanmodel[i - 1] = this.voc.isSatisfied(p);
                if (this.voc.getReason(p) == null && this.voc.getLevel(p) > 0) {
                    this.decisions.push(tempmodel.last());
                } else {
                    this.implied.push(tempmodel.last());
                }
            }
            ++i;
        }
        this.model = new int[tempmodel.size()];
        tempmodel.copyTo(this.model);
        if (this.realNumberOfVariables() > this.nVars()) {
            i = this.nVars() + 1;
            while (i <= this.realNumberOfVariables()) {
                if (this.voc.belongsToPool(i) && !this.voc.isUnassigned(p = this.voc.getFromPool(i))) {
                    tempmodel.push(this.voc.isSatisfied(p) ? i : -i);
                    this.userbooleanmodel[i - 1] = this.voc.isSatisfied(p);
                    if (this.voc.getReason(p) == null) {
                        this.decisions.push(tempmodel.last());
                    } else {
                        this.implied.push(tempmodel.last());
                    }
                }
                ++i;
            }
            this.fullmodel = new int[tempmodel.size()];
            tempmodel.moveTo(this.fullmodel);
        } else {
            this.fullmodel = this.model;
        }
    }

    private Constr forget(int var) {
        boolean satisfied = this.voc.isSatisfied(LiteralsUtils.toInternal(var));
        this.voc.forgets(var);
        Constr confl = satisfied ? this.reduceClausesForFalsifiedLiteral(LiteralsUtils.toInternal(-var)) : this.reduceClausesForFalsifiedLiteral(LiteralsUtils.toInternal(var));
        return confl;
    }

    private boolean setAndPropagate(int p) {
        if (this.voc.isUnassigned(p)) {
            assert (!this.trail.contains(p));
            assert (!this.trail.contains(LiteralsUtils.neg(p)));
            return this.assume(p) && this.propagate() == null;
        }
        return this.voc.isSatisfied(p);
    }

    @Override
    public int[] primeImplicant() {
        boolean noproblem;
        int d;
        assert (this.qhead == this.trail.size() + this.learnedLiterals.size());
        if (this.learnedLiterals.size() > 0) {
            this.qhead = this.trail.size();
        }
        if (this.isVerbose()) {
            System.out.printf("%s implied: %d, decision: %d %n", this.getLogPrefix(), this.implied.size(), this.decisions.size());
        }
        this.prime = new int[this.realNumberOfVariables() + 1];
        int i = 0;
        while (i < this.prime.length) {
            this.prime[i] = 0;
            ++i;
        }
        IteratorInt it = this.implied.iterator();
        while (it.hasNext()) {
            d = it.next();
            int p = LiteralsUtils.toInternal(d);
            this.prime[Math.abs((int)d)] = d;
            noproblem = this.setAndPropagate(p);
            assert (noproblem);
        }
        int removed = 0;
        int propagated = 0;
        int tested = 0;
        int l2propagation = 0;
        int i2 = 0;
        while (i2 < this.decisions.size()) {
            d = this.decisions.get(i2);
            assert (!this.voc.isFalsified(LiteralsUtils.toInternal(d)));
            if (this.voc.isSatisfied(LiteralsUtils.toInternal(d))) {
                this.prime[Math.abs((int)d)] = d;
                ++propagated;
            } else if (this.setAndPropagate(LiteralsUtils.toInternal(-d))) {
                boolean canBeRemoved = true;
                ++tested;
                int rightlevel = this.currentDecisionLevel();
                int j = i2 + 1;
                while (j < this.decisions.size()) {
                    ++l2propagation;
                    if (!this.setAndPropagate(LiteralsUtils.toInternal(this.decisions.get(j)))) {
                        canBeRemoved = false;
                        break;
                    }
                    ++j;
                }
                this.cancelUntil(rightlevel);
                if (canBeRemoved) {
                    this.forget(Math.abs(d));
                    Constr confl = this.propagate();
                    assert (confl == null);
                    ++removed;
                } else {
                    this.prime[Math.abs((int)d)] = d;
                    this.cancel();
                    assert (this.voc.isUnassigned(LiteralsUtils.toInternal(d)));
                    noproblem = this.setAndPropagate(LiteralsUtils.toInternal(d));
                    assert (noproblem);
                }
            } else {
                this.prime[Math.abs((int)d)] = d;
                this.cancel();
                noproblem = this.setAndPropagate(LiteralsUtils.toInternal(d));
                assert (noproblem);
            }
            ++i2;
        }
        this.cancelUntil(0);
        int[] implicant = new int[this.prime.length - removed - 1];
        int index = 0;
        int[] nArray = this.prime;
        int n = this.prime.length;
        int n2 = 0;
        while (n2 < n) {
            int i3 = nArray[n2];
            if (i3 != 0) {
                implicant[index++] = i3;
            }
            ++n2;
        }
        if (this.isVerbose()) {
            System.out.printf("%s prime implicant computation statistics%n", this.getLogPrefix());
            System.out.printf("%s implied: %d, decision: %d (removed %d, tested %d, propagated %d), l2 propagation:%d%n", this.getLogPrefix(), this.implied.size(), this.decisions.size(), removed, tested, propagated, l2propagation);
        }
        return implicant;
    }

    @Override
    public boolean primeImplicant(int p) {
        if (p == 0 || Math.abs(p) > this.realNumberOfVariables()) {
            throw new IllegalArgumentException("Use a valid Dimacs var id as argument!");
        }
        if (this.prime == null) {
            throw new UnsupportedOperationException("Call the primeImplicant method first!!!");
        }
        return this.prime[Math.abs(p)] == p;
    }

    @Override
    public boolean model(int var) {
        if (var <= 0 || var > this.realNumberOfVariables()) {
            throw new IllegalArgumentException("Use a valid Dimacs var id as argument!");
        }
        if (this.userbooleanmodel == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        return this.userbooleanmodel[var - 1];
    }

    @Override
    public void clearLearntClauses() {
        Iterator<Constr> iterator = this.learnts.iterator();
        while (iterator.hasNext()) {
            iterator.next().remove(this);
        }
        this.learnts.clear();
        this.learnedLiterals.clear();
    }

    protected final void reduceDB() {
        ++this.stats.reduceddb;
        this.slistener.cleaning();
        this.learnedConstraintsDeletionStrategy.reduce(this.learnts);
        System.gc();
    }

    protected void sortOnActivity() {
        this.learnts.sort(this.comparator);
    }

    protected void decayActivities() {
        this.order.varDecayActivity();
        this.claDecayActivity();
    }

    private void claDecayActivity() {
        this.claInc *= this.claDecay;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(boolean global) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, global);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        return this.isSatisfiable(assumps, false);
    }

    public final LearnedConstraintsDeletionStrategy fixedSize(final int maxsize) {
        return new LearnedConstraintsDeletionStrategy(){
            private static final long serialVersionUID = 1L;
            private final ConflictTimer aTimer;
            {
                this.aTimer = new ConflictTimerAdapter(n){
                    private static final long serialVersionUID = 1L;

                    public void run() {
                        Solver.this.needToReduceDB = true;
                    }
                };
            }

            @Override
            public void reduce(IVec<Constr> learnedConstrs) {
                int k = 0;
                int j = 0;
                int i = 0;
                while (i < Solver.this.learnts.size() && Solver.this.learnts.size() - k > maxsize) {
                    Constr c = Solver.this.learnts.get(i);
                    if (c.locked() || c.size() == 2) {
                        Solver.this.learnts.set(j++, Solver.this.learnts.get(i));
                    } else {
                        c.remove(Solver.this);
                        ++k;
                    }
                    ++i;
                }
                while (i < Solver.this.learnts.size()) {
                    Solver.this.learnts.set(j++, Solver.this.learnts.get(i));
                    ++i;
                }
                if (Solver.this.verbose) {
                    Solver.this.out.log(String.valueOf(Solver.this.getLogPrefix()) + "cleaning " + (Solver.this.learnts.size() - j) + " clauses out of " + Solver.this.learnts.size());
                }
                Solver.this.learnts.shrinkTo(j);
            }

            @Override
            public void onConflictAnalysis(Constr reason) {
            }

            @Override
            public void onClauseLearning(Constr outLearnt) {
            }

            public String toString() {
                return "Fixed size (" + maxsize + ") learned constraints deletion strategy";
            }

            @Override
            public void init() {
            }

            @Override
            public ConflictTimer getTimer() {
                return this.aTimer;
            }

            @Override
            public void onPropagation(Constr from) {
            }
        };
    }

    private LearnedConstraintsDeletionStrategy activityBased(ConflictTimer timer) {
        return new LearnedConstraintsDeletionStrategy(timer){
            private static final long serialVersionUID = 1L;
            private final ConflictTimer freeMem;
            {
                this.freeMem = conflictTimer;
            }

            @Override
            public void reduce(IVec<Constr> learnedConstrs) {
                Solver.this.sortOnActivity();
                int j = 0;
                int i = 0;
                while (i < Solver.this.learnts.size() / 2) {
                    Constr c = Solver.this.learnts.get(i);
                    if (c.locked() || c.size() == 2) {
                        Solver.this.learnts.set(j++, Solver.this.learnts.get(i));
                    } else {
                        c.remove(Solver.this);
                    }
                    ++i;
                }
                while (i < Solver.this.learnts.size()) {
                    Solver.this.learnts.set(j++, Solver.this.learnts.get(i));
                    ++i;
                }
                if (Solver.this.verbose) {
                    Solver.this.out.log(String.valueOf(Solver.this.getLogPrefix()) + "cleaning " + (Solver.this.learnts.size() - j) + " clauses out of " + Solver.this.learnts.size());
                }
                Solver.this.learnts.shrinkTo(j);
            }

            @Override
            public ConflictTimer getTimer() {
                return this.freeMem;
            }

            public String toString() {
                return "Memory based learned constraints deletion strategy";
            }

            @Override
            public void init() {
            }

            @Override
            public void onClauseLearning(Constr constr) {
            }

            @Override
            public void onConflictAnalysis(Constr reason) {
                if (reason.learnt()) {
                    Solver.this.claBumpActivity(reason);
                }
            }

            @Override
            public void onPropagation(Constr from) {
            }
        };
    }

    @Override
    public void setLearnedConstraintsDeletionStrategy(LearnedConstraintsDeletionStrategy lcds) {
        if (this.conflictCount != null) {
            this.conflictCount.add(lcds.getTimer());
            assert (this.learnedConstraintsDeletionStrategy != null);
            this.conflictCount.remove(this.learnedConstraintsDeletionStrategy.getTimer());
        }
        this.learnedConstraintsDeletionStrategy = lcds;
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        Lbool status = Lbool.UNDEFINED;
        boolean alreadylaunched = this.conflictCount != null;
        int howmany = this.voc.nVars();
        if (this.mseen.length <= howmany) {
            this.mseen = new boolean[howmany + 1];
        }
        this.trail.ensure(howmany);
        this.trailLim.ensure(howmany);
        this.learnedLiterals.ensure(howmany);
        this.decisions.clear();
        this.implied.clear();
        this.slistener.init(this);
        this.slistener.start();
        this.model = null;
        this.userbooleanmodel = null;
        this.prime = null;
        this.unsatExplanationInTermsOfAssumptions = null;
        if (!alreadylaunched || !this.keepHot) {
            this.order.init();
        }
        this.learnedConstraintsDeletionStrategy.init();
        int learnedLiteralsLimit = this.trail.size();
        this.qhead = 0;
        int i = learnedLiteralsLimit - 1;
        while (i >= 0) {
            int p = this.trail.get(i);
            IVec<Undoable> undos = this.voc.undos(p);
            assert (undos != null);
            int size = undos.size();
            while (size > 0) {
                undos.last().undo(p);
                undos.pop();
                --size;
            }
            --i;
        }
        IteratorInt iterator = this.learnedLiterals.iterator();
        while (iterator.hasNext()) {
            this.enqueue(iterator.next());
        }
        Constr confl = this.propagate();
        if (confl != null) {
            this.analyzeAtRootLevel(confl);
            this.slistener.conflictFound(confl, 0, 0);
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            this.cancelLearntLiterals(learnedLiteralsLimit);
            return false;
        }
        IteratorInt iterator2 = assumps.iterator();
        while (iterator2.hasNext()) {
            int assump = iterator2.next();
            int p = this.voc.getFromPool(assump);
            if ((this.voc.isSatisfied(p) || this.assume(p)) && (confl = this.propagate()) == null) continue;
            if (confl == null) {
                this.slistener.conflictFound(p);
                this.unsatExplanationInTermsOfAssumptions = this.analyzeFinalConflictInTermsOfAssumptions(null, assumps, p);
                this.unsatExplanationInTermsOfAssumptions.push(assump);
            } else {
                this.slistener.conflictFound(confl, this.decisionLevel(), this.trail.size());
                this.unsatExplanationInTermsOfAssumptions = this.analyzeFinalConflictInTermsOfAssumptions(confl, assumps, -1);
            }
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            this.cancelLearntLiterals(learnedLiteralsLimit);
            return false;
        }
        this.rootLevel = this.decisionLevel();
        if (!alreadylaunched || !this.keepHot) {
            this.order.init();
        }
        this.learner.init();
        if (!alreadylaunched) {
            this.conflictCount = new ConflictTimerContainer();
            this.conflictCount.add(this.restarter);
            this.conflictCount.add(this.learnedConstraintsDeletionStrategy.getTimer());
        }
        boolean firstTimeGlobal = false;
        if (this.timeBasedTimeout) {
            if (!global || this.timer == null) {
                firstTimeGlobal = true;
                this.undertimeout = true;
                TimerTask stopMe = new TimerTask(){

                    public void run() {
                        Solver.this.undertimeout = false;
                    }
                };
                this.timer = new Timer(true);
                this.timer.schedule(stopMe, this.timeout);
            }
        } else if (!global || !alreadylaunched) {
            firstTimeGlobal = true;
            this.undertimeout = true;
            ConflictTimerAdapter conflictTimeout = new ConflictTimerAdapter((int)this.timeout){
                private static final long serialVersionUID = 1L;

                public void run() {
                    Solver.this.undertimeout = false;
                }
            };
            this.conflictCount.add(conflictTimeout);
        }
        if (!global || firstTimeGlobal) {
            this.restarter.init(this.params, this.stats);
            this.timebegin = System.currentTimeMillis();
        }
        this.needToReduceDB = false;
        this.lastConflictMeansUnsat = true;
        while (status == Lbool.UNDEFINED && this.undertimeout && this.lastConflictMeansUnsat) {
            int before = this.trail.size();
            this.unitClauseProvider.provideUnitClauses(this);
            this.stats.importedUnits += this.trail.size() - before;
            status = this.search(assumps);
            if (status != Lbool.UNDEFINED) continue;
            this.restarter.onRestart();
            this.slistener.restarting();
        }
        this.cancelUntil(0);
        this.cancelLearntLiterals(learnedLiteralsLimit);
        if (!global && this.timeBasedTimeout && this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.slistener.end(status);
        if (!this.undertimeout) {
            String message = " Timeout (" + this.timeout + (this.timeBasedTimeout ? "s" : " conflicts") + ") exceeded";
            throw new TimeoutException(message);
        }
        if (status == Lbool.UNDEFINED && !this.lastConflictMeansUnsat) {
            throw new TimeoutException("Cannot decide the satisfiability");
        }
        return this.model != null;
    }

    @Override
    public void printInfos(PrintWriter out) {
        this.printInfos(out, this.prefix);
    }

    @Override
    public void printInfos(PrintWriter out, String prefix) {
        out.print(prefix);
        out.println("constraints type ");
        long total = 0L;
        for (Map.Entry<String, Counter> entry : this.constrTypes.entrySet()) {
            out.println(String.valueOf(prefix) + entry.getKey() + " => " + entry.getValue());
            total += (long)entry.getValue().getValue();
        }
        out.print(prefix);
        out.print(total);
        out.println(" constraints processed.");
    }

    public void printLearntClausesInfos(PrintWriter out, String prefix) {
        HashMap<String, Counter> learntTypes = new HashMap<String, Counter>();
        Iterator<Constr> it = this.learnts.iterator();
        while (it.hasNext()) {
            String type = it.next().getClass().getName();
            Counter count = (Counter)learntTypes.get(type);
            if (count == null) {
                learntTypes.put(type, new Counter());
                continue;
            }
            count.inc();
        }
        out.print(prefix);
        out.println("learnt constraints type ");
        for (Map.Entry entry : learntTypes.entrySet()) {
            out.println(String.valueOf(prefix) + (String)entry.getKey() + " => " + entry.getValue());
        }
    }

    @Override
    public SolverStats getStats() {
        return this.stats;
    }

    protected void initStats(SolverStats myStats) {
        this.stats = myStats;
    }

    @Override
    public IOrder getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(IOrder h) {
        this.order = h;
        this.order.setLits(this.voc);
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    @Override
    public void reset() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.trail.clear();
        this.trailLim.clear();
        this.qhead = 0;
        Iterator<Constr> iterator = this.constrs.iterator();
        while (iterator.hasNext()) {
            iterator.next().remove(this);
        }
        this.constrs.clear();
        this.clearLearntClauses();
        this.voc.resetPool();
        this.dsfactory.reset();
        this.stats.reset();
        this.constrTypes.clear();
    }

    @Override
    public int nVars() {
        if (this.declaredMaxVarId == 0) {
            return this.voc.nVars();
        }
        return this.declaredMaxVarId;
    }

    protected IConstr addConstr(Constr constr) {
        if (constr == null) {
            Counter count = this.constrTypes.get("ignored satisfied constraints");
            if (count == null) {
                this.constrTypes.put("ignored satisfied constraints", new Counter());
            } else {
                count.inc();
            }
        } else {
            this.constrs.push(constr);
            String type = constr.getClass().getName();
            Counter count = this.constrTypes.get(type);
            if (count == null) {
                this.constrTypes.put(type, new Counter());
            } else {
                count.inc();
            }
        }
        return constr;
    }

    public DataStructureFactory getDSFactory() {
        return this.dsfactory;
    }

    public IVecInt getOutLearnt() {
        return this.moutLearnt;
    }

    public IConstr getIthConstr(int i) {
        return this.constrs.get(i);
    }

    @Override
    public void printStat(PrintStream out, String prefix) {
        this.printStat(new PrintWriter(out, true), prefix);
    }

    @Override
    public void printStat(PrintWriter out) {
        this.printStat(out, this.prefix);
    }

    @Override
    public void printStat(PrintWriter out, String prefix) {
        this.stats.printStat(out, prefix);
        double cputime = ((double)System.currentTimeMillis() - this.timebegin) / 1000.0;
        out.println(String.valueOf(prefix) + "speed (assignments/second)\t: " + (double)this.stats.propagations / cputime);
        this.order.printStat(out, prefix);
        this.printLearntClausesInfos(out, prefix);
    }

    @Override
    public String toString(String prefix) {
        StringBuffer stb = new StringBuffer();
        Object[] objs = new Object[]{this.dsfactory, this.learner, this.params, this.order, this.simplifier, this.restarter, this.learnedConstraintsDeletionStrategy};
        stb.append(prefix);
        stb.append("--- Begin Solver configuration ---");
        stb.append("\n");
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            stb.append(prefix);
            stb.append(o.toString());
            stb.append("\n");
            ++n2;
        }
        stb.append(prefix);
        stb.append("timeout=");
        if (this.timeBasedTimeout) {
            stb.append(this.timeout / 1000L);
            stb.append("s\n");
        } else {
            stb.append(this.timeout);
            stb.append(" conflicts\n");
        }
        stb.append(prefix);
        stb.append("DB Simplification allowed=");
        stb.append(this.isDBSimplificationAllowed);
        stb.append("\n");
        stb.append(prefix);
        if (this.isSolverKeptHot()) {
            stb.append("Heuristics kept accross calls (keep the solver \"hot\")\n");
            stb.append(prefix);
        }
        stb.append("Listener: ");
        stb.append(this.slistener);
        stb.append("\n");
        stb.append(prefix);
        stb.append("--- End Solver configuration ---");
        return stb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public int getTimeout() {
        return (int)(this.timeBasedTimeout ? this.timeout / 1000L : this.timeout);
    }

    @Override
    public long getTimeoutMs() {
        if (!this.timeBasedTimeout) {
            throw new UnsupportedOperationException("The timeout is given in number of conflicts!");
        }
        return this.timeout;
    }

    @Override
    public void setExpectedNumberOfClauses(int nb) {
        this.constrs.ensure(nb);
    }

    @Override
    public Map<String, Number> getStat() {
        return this.stats.toMap();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        if (this.isSatisfiable()) {
            return this.model();
        }
        return null;
    }

    @Override
    public int[] findModel(IVecInt assumps) throws TimeoutException {
        if (this.isSatisfiable(assumps)) {
            return this.model();
        }
        return null;
    }

    @Override
    public boolean isDBSimplificationAllowed() {
        return this.isDBSimplificationAllowed;
    }

    @Override
    public void setDBSimplificationAllowed(boolean status) {
        this.isDBSimplificationAllowed = status;
    }

    @Override
    public int nextFreeVarId(boolean reserve) {
        return this.voc.nextFreeVarId(reserve);
    }

    @Override
    public IConstr addBlockingClause(IVecInt literals) throws ContradictionException {
        return this.addClause(literals);
    }

    @Override
    public void unset(int p) {
        if (this.voc.isUnassigned(p) || this.trail.isEmpty()) {
            return;
        }
        int current = this.trail.last();
        while (current != p) {
            this.undoOne();
            if (this.trail.isEmpty()) {
                return;
            }
            current = this.trail.last();
        }
        this.undoOne();
        this.qhead = this.trail.size();
    }

    @Override
    public void setLogPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getLogPrefix() {
        return this.prefix;
    }

    @Override
    public IVecInt unsatExplanation() {
        VecInt copy = new VecInt(this.unsatExplanationInTermsOfAssumptions.size());
        this.unsatExplanationInTermsOfAssumptions.copyTo(copy);
        return copy;
    }

    @Override
    public int[] modelWithInternalVariables() {
        int[] nmodel;
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        if (this.nVars() == this.realNumberOfVariables()) {
            nmodel = new int[this.model.length];
            System.arraycopy(this.model, 0, nmodel, 0, nmodel.length);
        } else {
            nmodel = new int[this.fullmodel.length];
            System.arraycopy(this.fullmodel, 0, nmodel, 0, nmodel.length);
        }
        return nmodel;
    }

    @Override
    public int realNumberOfVariables() {
        return this.voc.nVars();
    }

    @Override
    public void stop() {
        this.expireTimeout();
    }

    @Override
    public void backtrack(int[] reason) {
        VecInt clause = new VecInt(reason.length);
        int[] nArray = reason;
        int n = reason.length;
        int n2 = 0;
        while (n2 < n) {
            int d = nArray[n2];
            clause.push(LiteralsUtils.toInternal(d));
            ++n2;
        }
        this.sharedConflict = this.dsfactory.createUnregisteredClause(clause);
        this.learn(this.sharedConflict);
    }

    @Override
    public Lbool truthValue(int literal) {
        int p = LiteralsUtils.toInternal(literal);
        if (this.voc.isFalsified(p)) {
            return Lbool.FALSE;
        }
        if (this.voc.isSatisfied(p)) {
            return Lbool.TRUE;
        }
        return Lbool.UNDEFINED;
    }

    @Override
    public int currentDecisionLevel() {
        return this.decisionLevel();
    }

    @Override
    public int[] getLiteralsPropagatedAt(int decisionLevel) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public void suggestNextLiteralToBranchOn(int l) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    protected boolean isNeedToReduceDB() {
        return this.needToReduceDB;
    }

    @Override
    public void setNeedToReduceDB(boolean needToReduceDB) {
        this.needToReduceDB = needToReduceDB;
    }

    @Override
    public void setLogger(ILogAble out) {
        this.out = out;
    }

    @Override
    public ILogAble getLogger() {
        return this.out;
    }

    @Override
    public double[] getVariableHeuristics() {
        return this.order.getVariableHeuristics();
    }

    public IVec<Constr> getLearnedConstraints() {
        return this.learnts;
    }

    @Override
    public void setLearnedConstraintsDeletionStrategy(ConflictTimer timer, LearnedConstraintsEvaluationType evaluation) {
        if (this.conflictCount != null) {
            this.conflictCount.add(timer);
            this.conflictCount.remove(this.learnedConstraintsDeletionStrategy.getTimer());
        }
        switch (evaluation) {
            case ACTIVITY: {
                this.learnedConstraintsDeletionStrategy = this.activityBased(timer);
                break;
            }
            case LBD: {
                this.learnedConstraintsDeletionStrategy = new GlucoseLCDS(timer);
                break;
            }
            case LBD2: {
                this.learnedConstraintsDeletionStrategy = new Glucose2LCDS(timer);
            }
        }
        if (this.conflictCount != null) {
            this.learnedConstraintsDeletionStrategy.init();
        }
    }

    @Override
    public void setLearnedConstraintsDeletionStrategy(LearnedConstraintsEvaluationType evaluation) {
        ConflictTimer aTimer = this.learnedConstraintsDeletionStrategy.getTimer();
        switch (evaluation) {
            case ACTIVITY: {
                this.learnedConstraintsDeletionStrategy = this.activityBased(aTimer);
                break;
            }
            case LBD: {
                this.learnedConstraintsDeletionStrategy = new GlucoseLCDS(aTimer);
                break;
            }
            case LBD2: {
                this.learnedConstraintsDeletionStrategy = new Glucose2LCDS(aTimer);
            }
        }
        if (this.conflictCount != null) {
            this.learnedConstraintsDeletionStrategy.init();
        }
    }

    @Override
    public boolean isSolverKeptHot() {
        return this.keepHot;
    }

    @Override
    public void setKeepSolverHot(boolean keepHot) {
        this.keepHot = keepHot;
    }

    @Override
    public IConstr addClauseOnTheFly(int[] literals) {
        ArrayList<Integer> lliterals = new ArrayList<Integer>();
        int[] nArray = literals;
        int n = literals.length;
        int n2 = 0;
        while (n2 < n) {
            Integer d = nArray[n2];
            lliterals.add(d);
            ++n2;
        }
        Collections.sort(lliterals, this.dimacsLevel);
        VecInt clause = new VecInt(literals.length);
        Iterator iterator = lliterals.iterator();
        while (iterator.hasNext()) {
            int d = (Integer)iterator.next();
            clause.push(LiteralsUtils.toInternal(d));
        }
        this.sharedConflict = this.dsfactory.createUnregisteredClause(clause);
        this.sharedConflict.register();
        this.addConstr(this.sharedConflict);
        VecInt reason = new VecInt();
        this.sharedConflict.calcReasonOnTheFly(-1, this.trail, reason);
        Set<Integer> subset = this.fromLastDecisionLevel(reason);
        while (!this.trail.isEmpty() && !subset.contains(this.trail.last())) {
            this.undoOne();
            if (this.trailLim.isEmpty() || this.trailLim.last() != this.trail.size()) continue;
            this.trailLim.pop();
        }
        return this.sharedConflict;
    }

    @Override
    public ISolver getSolvingEngine() {
        return this;
    }

    @Override
    public IConstr addAtMostOnTheFly(int[] literals, int degree) {
        VecInt clause = new VecInt(literals.length);
        int[] nArray = literals;
        int n = literals.length;
        int n2 = 0;
        while (n2 < n) {
            int d = nArray[n2];
            clause.push(LiteralsUtils.toInternal(-d));
            ++n2;
        }
        VecInt copy = new VecInt(clause.size());
        clause.copyTo(copy);
        this.sharedConflict = this.dsfactory.createUnregisteredCardinalityConstraint(copy, literals.length - degree);
        this.sharedConflict.register();
        this.addConstr(this.sharedConflict);
        VecInt reason = new VecInt();
        this.sharedConflict.calcReasonOnTheFly(-1, this.trail, reason);
        Set<Integer> subset = this.fromLastDecisionLevel(reason);
        while (!this.trail.isEmpty() && !subset.contains(this.trail.last())) {
            this.undoOne();
            if (this.trailLim.isEmpty() || this.trailLim.last() != this.trail.size()) continue;
            this.trailLim.pop();
        }
        return this.sharedConflict;
    }

    protected Set<Integer> fromLastDecisionLevel(IVecInt lits) {
        HashSet<Integer> subset = new HashSet<Integer>();
        int max = -1;
        int i = 0;
        while (i < lits.size()) {
            int q = lits.get(i);
            int level = this.voc.getLevel(q);
            if (level > max) {
                subset.clear();
                subset.add(q);
                max = level;
            } else if (level == max) {
                subset.add(q);
            }
            ++i;
        }
        return subset;
    }

    @Override
    public void setUnitClauseProvider(UnitClauseProvider ucp) {
        this.unitClauseProvider = ucp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Glucose2LCDS
    extends GlucoseLCDS {
        private static final long serialVersionUID = 1L;

        Glucose2LCDS(ConflictTimer timer) {
            super(timer);
        }

        @Override
        public String toString() {
            return "Glucose 2 learned constraints deletion strategy";
        }

        @Override
        public void onPropagation(Constr from) {
            int nblevel;
            if (from.getActivity() > 2.0 && (double)(nblevel = this.computeLBD(from)) < from.getActivity()) {
                ++((Solver)Solver.this).stats.updateLBD;
                from.setActivity(nblevel);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GlucoseLCDS
    implements LearnedConstraintsDeletionStrategy {
        private static final long serialVersionUID = 1L;
        private int[] flags = new int[0];
        private int flag = 0;
        private final ConflictTimer clauseManagement;

        GlucoseLCDS(ConflictTimer timer) {
            this.clauseManagement = timer;
        }

        @Override
        public void reduce(IVec<Constr> learnedConstrs) {
            int j;
            Solver.this.sortOnActivity();
            int i = j = learnedConstrs.size() / 2;
            while (i < learnedConstrs.size()) {
                Constr c = learnedConstrs.get(i);
                if (c.locked() || c.getActivity() <= 2.0) {
                    learnedConstrs.set(j++, Solver.this.learnts.get(i));
                } else {
                    c.remove(Solver.this);
                }
                ++i;
            }
            if (Solver.this.verbose) {
                Solver.this.out.log(String.valueOf(Solver.this.getLogPrefix()) + "cleaning " + (learnedConstrs.size() - j) + " clauses out of " + learnedConstrs.size() + " with flag " + this.flag + "/" + ((Solver)Solver.this).stats.conflicts);
            }
            Solver.this.learnts.shrinkTo(j);
        }

        @Override
        public ConflictTimer getTimer() {
            return this.clauseManagement;
        }

        public String toString() {
            return "Glucose learned constraints deletion strategy";
        }

        @Override
        public void init() {
            int howmany = Solver.this.voc.nVars();
            if (this.flags.length <= howmany) {
                this.flags = new int[howmany + 1];
            }
            this.flag = 0;
            this.clauseManagement.reset();
        }

        @Override
        public void onClauseLearning(Constr constr) {
            int nblevel = this.computeLBD(constr);
            constr.incActivity(nblevel);
        }

        protected int computeLBD(Constr constr) {
            int nblevel = 1;
            ++this.flag;
            int i = 1;
            while (i < constr.size()) {
                int currentLevel = Solver.this.voc.getLevel(constr.get(i));
                if (this.flags[currentLevel] != this.flag) {
                    this.flags[currentLevel] = this.flag;
                    ++nblevel;
                }
                ++i;
            }
            return nblevel;
        }

        @Override
        public void onConflictAnalysis(Constr reason) {
        }

        @Override
        public void onPropagation(Constr from) {
        }
    }
}

