/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.server.settings;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;
import org.eclipse.gyrex.server.settings.ListValueConverter;
import org.eclipse.gyrex.server.settings.SingleValueConverter;
import org.eclipse.gyrex.server.settings.SystemSetting;
import org.eclipse.gyrex.server.settings.ValueConverter;

public final class SystemSettingBuilder<T> {
    @VisibleForTesting
    String environmentVariable;
    @VisibleForTesting
    String systemProperty;
    @VisibleForTesting
    String description;
    @VisibleForTesting
    final Class<?> valueType;
    private T defaultValue;
    private final ValueConverter<T> valueConverter;

    static <T> SystemSettingBuilder<List<T>> multiValued(Class<T> valueType) {
        return new SystemSettingBuilder<List<T>>(new ListValueConverter<T>(valueType), valueType);
    }

    static <T> SystemSettingBuilder<T> singleValued(Class<T> valueType) {
        return new SystemSettingBuilder<T>(new SingleValueConverter<T>(valueType), valueType);
    }

    private static String toEnvironmentVariableName(CharSequence systemProperty) {
        StringBuilder result = new StringBuilder(systemProperty.length());
        int i = 0;
        while (i < systemProperty.length()) {
            char c = systemProperty.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                result.append(c);
            } else {
                result.append('_');
            }
            ++i;
        }
        return result.toString();
    }

    @VisibleForTesting
    SystemSettingBuilder(ValueConverter<T> valueConverter, Class<?> valueType) {
        this.valueConverter = valueConverter;
        this.valueType = valueType;
    }

    public SystemSetting<T> create() {
        String environmentVariable = this.environmentVariable == null ? SystemSettingBuilder.toEnvironmentVariableName(Objects.requireNonNull(this.systemProperty, "Please specify at least a system property!")) : this.environmentVariable;
        return new SystemSetting<T>(environmentVariable, this.systemProperty, this.description, this.valueConverter, this.defaultValue);
    }

    public SystemSettingBuilder<T> description(String description) {
        this.description = description;
        return this;
    }

    public SystemSettingBuilder<T> environmentVariable(String environmentVariable) {
        this.environmentVariable = environmentVariable;
        return this;
    }

    public SystemSettingBuilder<T> systemProperty(String systemProperty) {
        this.systemProperty = systemProperty;
        return this;
    }

    public SystemSettingBuilder<T> usingDefault(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }
}

