/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.junit;

import com.google.common.base.Preconditions;
import org.eclipse.gyrex.common.services.BundleServiceHelper;
import org.junit.rules.ExternalResource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiResources
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiResources.class);
    private final BundleServiceHelper bundleServiceHelper;
    private final BundleContext bundleContext;

    public OsgiResources(BundleContext context) {
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)context, (Object)"BundleContext must not be null");
        this.bundleServiceHelper = new BundleServiceHelper(this.bundleContext);
    }

    protected void after() {
        this.bundleServiceHelper.dispose();
    }

    public <T> T getService(Class<T> serviceInterface) {
        return (T)this.bundleServiceHelper.trackService(serviceInterface).getService();
    }

    public void startBundle(String symbolicName) {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = this.bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Bundle bundle = bundleArray[n2];
                if (bundle.getSymbolicName().equals(symbolicName)) {
                    if ((bundle.getState() & 3) != 0) {
                        LOG.warn("Found un-resolved candidate for BSN '{}': {}", (Object)symbolicName, (Object)bundle);
                    } else {
                        try {
                            bundle.start(1);
                        }
                        catch (BundleException e) {
                            LOG.warn("Erro starting bundle '{}' ({}): {}", new Object[]{symbolicName, bundle, e.getMessage(), e});
                            break block6;
                        }
                        return;
                    }
                }
            }
            ++n2;
        }
        throw new AssertionError((Object)String.format("No bundle matching symbolic name '%s' started.", symbolicName));
    }
}

