/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.server.settings;

import java.util.ArrayList;
import org.eclipse.gyrex.server.settings.SystemSetting;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SystemSettingTest {
    public static final String PROPERTY_NAME = "systemSettingTestProperty";

    @After
    public void cleanUpSettings() {
        System.clearProperty(PROPERTY_NAME);
    }

    @Test
    public void testGetOrFail() {
        String value = "sample";
        SystemSetting setting = SystemSetting.newIntegerSetting((String)PROPERTY_NAME, (String)"testingPurposes").create();
        System.setProperty(PROPERTY_NAME, "sample");
        try {
            setting.getOrFail();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        System.setProperty(PROPERTY_NAME, "1");
        Assert.assertEquals((Object)1, (Object)setting.get());
    }

    @Test
    public void testReadList() {
        SystemSetting setting = SystemSetting.newMultiValueStringSetting((String)PROPERTY_NAME, (String)"testingPurposes").create();
        System.setProperty(PROPERTY_NAME, "a");
        ArrayList<String> values = new ArrayList<String>();
        values.add("a");
        Assert.assertEquals(values, (Object)setting.get());
        System.setProperty(PROPERTY_NAME, "a,b,c");
        values.add("b");
        values.add("c");
        Assert.assertEquals(values, (Object)setting.get());
    }

    @Test
    public void testReadSystem() {
        SystemSetting setting = SystemSetting.newStringSetting((String)PROPERTY_NAME, (String)"testingPurposes").create();
        Assert.assertEquals(null, (Object)setting.get());
        String value = "sample";
        System.setProperty(PROPERTY_NAME, "sample");
        Assert.assertEquals((Object)"sample", (Object)setting.get());
    }

    @Test
    public void testUseDefault() {
        SystemSetting setting = SystemSetting.newLongSetting((String)PROPERTY_NAME, (String)"testingPurposes").usingDefault((Object)321L).create();
        Assert.assertEquals((Object)321L, (Object)setting.get());
    }
}

