/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.tests.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.SortedSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.manager.IApplicationManager;
import org.eclipse.gyrex.http.application.provider.ApplicationProvider;
import org.eclipse.gyrex.http.internal.application.manager.IAutomountService;
import org.eclipse.gyrex.http.tests.internal.Activator;
import org.eclipse.gyrex.junit.GyrexServerResource;
import org.eclipse.gyrex.junit.OsgiResources;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class AutomounterBlackBoxTests {
    @ClassRule
    public static GyrexServerResource server = new GyrexServerResource();
    @Rule
    public OsgiResources osgi = new OsgiResources(Activator.getBundleContext());

    @Test
    public void testAutomount() {
        BundleContext context = Activator.getBundleContext();
        TestAppProvider appProvider = new TestAppProvider();
        String applicationId = "my-app-" + System.nanoTime();
        String url = "http:/myapp";
        Hashtable<String, String> propereties = new Hashtable<String, String>();
        ((Dictionary)propereties).put("automount.applicationId", applicationId);
        ((Dictionary)propereties).put("automount.url", "http:/myapp");
        ServiceRegistration serviceRegistration = context.registerService(ApplicationProvider.class, (Object)appProvider, propereties);
        this.osgi.startBundle("org.eclipse.gyrex.http");
        this.osgi.getService(IAutomountService.class);
        IApplicationManager manager = (IApplicationManager)this.osgi.getService(IApplicationManager.class);
        Assert.assertTrue((boolean)manager.isRegistered(applicationId));
        SortedSet mounts = manager.getMounts(applicationId);
        Assert.assertNotNull((Object)mounts);
        Assert.assertTrue((boolean)mounts.contains("http:/myapp"));
        serviceRegistration.unregister();
    }

    static class TestApp
    extends Application {
        TestApp(String id, IRuntimeContext context) {
            super(id, context);
        }
    }

    static class TestAppProvider
    extends ApplicationProvider {
        TestAppProvider() {
            super(TestAppProvider.class.getSimpleName());
        }

        public Application createApplication(String applicationId, IRuntimeContext context) throws CoreException {
            return new TestApp(applicationId, context);
        }
    }
}

