/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal.application.manager;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.http.application.manager.ApplicationRegistrationException;
import org.eclipse.gyrex.http.application.manager.IApplicationManager;
import org.eclipse.gyrex.http.application.manager.MountConflictException;
import org.eclipse.gyrex.http.application.provider.ApplicationProvider;
import org.eclipse.gyrex.http.internal.application.manager.IAutomountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomountComponent
implements IAutomountService {
    public static final String PROPERTY_AUTOMOUNT_URL = "automount.url";
    public static final String PROPERTY_AUTOMOUNT_RUNTIME_CONTEXT_PATH = "automount.runtimeContextPath";
    public static final String PROPERTY_AUTOMOUNT_APPLICATION_ID = "automount.applicationId";
    private IApplicationManager applicationManager;
    private IRuntimeContextRegistry runtimeContextRegistry;
    private static final Logger LOG = LoggerFactory.getLogger(AutomountComponent.class);

    private Map<String, String> extractStringValueProperties(Map<String, Object> properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            if (!(e.getValue() instanceof String)) continue;
            result.put(e.getKey(), (String)e.getValue());
        }
        return result;
    }

    private String getApplicationId(Map<String, Object> properties) {
        Object applicationIdValue = properties.get(PROPERTY_AUTOMOUNT_APPLICATION_ID);
        if (applicationIdValue == null) {
            return (String)properties.get("component.name");
        }
        Preconditions.checkState((boolean)(applicationIdValue instanceof String), (Object)"The provider property 'applicationId' must be of type String!");
        return (String)applicationIdValue;
    }

    public IApplicationManager getApplicationManager() {
        IApplicationManager manager = this.applicationManager;
        Preconditions.checkState((manager != null ? 1 : 0) != 0, (Object)"inactive");
        return manager;
    }

    private IPath getAutomountContextPath(Map<String, Object> properties) {
        Object contextValue = properties.get(PROPERTY_AUTOMOUNT_RUNTIME_CONTEXT_PATH);
        if (contextValue == null) {
            return Path.ROOT;
        }
        if (contextValue instanceof IPath) {
            return (IPath)contextValue;
        }
        Preconditions.checkState((boolean)(contextValue instanceof String), (Object)"The provider property 'automountRuntimeContext' must be of type String!");
        if (Strings.isNullOrEmpty((String)((String)contextValue))) {
            return Path.ROOT;
        }
        return new Path((String)contextValue).makeAbsolute();
    }

    private List<String> getAutomountUrls(Map<String, Object> properties) {
        Object urlValue = properties.get(PROPERTY_AUTOMOUNT_URL);
        if (urlValue == null) {
            return null;
        }
        Preconditions.checkState((boolean)(urlValue instanceof String), (Object)"The provider property 'automountUrl' must be of type String!");
        return Arrays.asList((String)urlValue);
    }

    public IRuntimeContextRegistry getRuntimeContextRegistry() {
        IRuntimeContextRegistry registry = this.runtimeContextRegistry;
        Preconditions.checkState((registry != null ? 1 : 0) != 0, (Object)"inactive");
        return registry;
    }

    private void logAlreadyRegistered(ApplicationProvider provider, Collection<String> urls, String applicationId) {
        LOG.debug("Skipping auto-mount of application '{}' (provider '{}'). Already found a registration.", (Object)applicationId, (Object)provider.getId());
        SortedSet<String> mounts = this.getApplicationManager().getMounts(applicationId);
        ArrayList<String> urlsNotMounted = new ArrayList<String>(urls);
        for (String url : urls) {
            if (!mounts.contains(url)) continue;
            urlsNotMounted.remove(url);
        }
        if (!urlsNotMounted.isEmpty()) {
            LOG.warn("Auto-mount not possible for url(s) '{}'. The exising application '{}' is configured differntly.", urlsNotMounted, (Object)applicationId);
        }
    }

    public void mountProvider(ApplicationProvider provider, Map<String, Object> properties) {
        LOG.debug("Discovering auto-mounts for provider '{}'.", (Object)provider.getId());
        List<String> urls = this.getAutomountUrls(properties);
        if (urls == null || urls.isEmpty()) {
            LOG.debug("No auto-mount url configured for provider '{}'.", (Object)provider.getId());
            return;
        }
        String applicationId = this.getApplicationId(properties);
        if (this.getApplicationManager().isRegistered(applicationId)) {
            this.logAlreadyRegistered(provider, urls, applicationId);
            return;
        }
        IPath contextPath = this.getAutomountContextPath(properties);
        IRuntimeContext context = this.getRuntimeContextRegistry().get(contextPath);
        if (context == null) {
            LOG.error("Unable to auto-mount application '{}'. Runtime context '{}' not defined!", (Object)applicationId, (Object)contextPath);
            return;
        }
        LOG.info("Creating application '{}' at context '{}' mounted to urls '{}' as adviced by auto-mount configuration of provider '{}'.", new Object[]{applicationId, contextPath, urls, provider.getId()});
        try {
            this.getApplicationManager().register(applicationId, provider.getId(), context, this.extractStringValueProperties(properties));
        }
        catch (ApplicationRegistrationException e) {
            this.logAlreadyRegistered(provider, urls, applicationId);
            return;
        }
        for (String url : urls) {
            try {
                this.getApplicationManager().mount(url, applicationId);
            }
            catch (IllegalArgumentException | MalformedURLException | MountConflictException e) {
                LOG.error("Unable to auto-mount url '{}' for application '{}'. {}", new Object[]{url, applicationId, ((Throwable)e).getMessage(), e});
            }
        }
    }

    public void setApplicationManager(IApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setRuntimeContextRegistry(IRuntimeContextRegistry runtimeContextRegistry) {
        this.runtimeContextRegistry = runtimeContextRegistry;
    }
}

