/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.admin.ui.logback.configuration.wizard.AppenderConfigurationWizardAdapter;
import org.eclipse.gyrex.admin.ui.logback.configuration.wizard.AppenderConfigurationWizardSession;
import org.eclipse.gyrex.admin.ui.logback.internal.AppenderWizardPage;
import org.eclipse.gyrex.logback.config.model.Appender;
import org.eclipse.gyrex.logback.config.model.LogbackConfig;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddEditAppenderWizard
extends Wizard {
    private static final Logger LOG = LoggerFactory.getLogger(AddEditAppenderWizard.class);
    private static final IWizardPage[] NO_PAGES = new IWizardPage[0];
    private final Map<String, AppenderConfigurationWizardSession> sessionsByAppenderTypeId = new HashMap<String, AppenderConfigurationWizardSession>(2);
    private final LogbackConfig logbackConfig;
    private final Appender existingAppender;
    private final AppenderWizardPage appenderTypeWizardPage;
    private AppenderConfigurationWizardSession currentSession;

    public AddEditAppenderWizard(LogbackConfig logbackConfig, Appender existingAppender) {
        this.logbackConfig = logbackConfig;
        this.existingAppender = existingAppender;
        this.appenderTypeWizardPage = new AppenderWizardPage();
        if (existingAppender != null) {
            this.appenderTypeWizardPage.initializeFromExistingAppender(existingAppender);
        }
        this.setForcePreviousAndNextButtons(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.appenderTypeWizardPage);
    }

    public boolean canFinish() {
        return this.appenderTypeWizardPage.isPageComplete() && this.currentSession != null && this.currentSession.canFinish();
    }

    void clearCurrentAppenderConfigurationSession() {
        this.currentSession = null;
        this.getContainer().showPage((IWizardPage)this.appenderTypeWizardPage);
    }

    private AppenderConfigurationWizardSession findExistingSessionOrCreateNew(String id, String name) {
        AppenderConfigurationWizardSession session;
        if (!this.sessionsByAppenderTypeId.containsKey(id)) {
            session = new AppenderConfigurationWizardSession(id, name);
            this.sessionsByAppenderTypeId.put(id, session);
        }
        session = this.sessionsByAppenderTypeId.get(id);
        return session;
    }

    public Appender getAppender() {
        Preconditions.checkState((this.currentSession != null ? 1 : 0) != 0, (Object)"No appender type selected!");
        Appender appender = this.currentSession.getAppender();
        Preconditions.checkState((appender != null ? 1 : 0) != 0, (String)"No appender initialized for appender type '%s'!", (Object[])new Object[]{this.currentSession.getAppenderTypeId()});
        return appender;
    }

    public LogbackConfig getLogbackConfig() {
        return this.logbackConfig;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] sessionPages;
        IWizardPage[] iWizardPageArray = sessionPages = this.currentSession != null ? this.currentSession.getPages() : NO_PAGES;
        if (page == this.appenderTypeWizardPage) {
            if (sessionPages.length > 0) {
                return sessionPages[0];
            }
            return null;
        }
        int i = 0;
        while (i < sessionPages.length) {
            if (page == sessionPages[i]) {
                if (i + 1 < sessionPages.length) {
                    return sessionPages[i + 1];
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage[] sessionPages;
        IWizardPage[] iWizardPageArray = sessionPages = this.currentSession != null ? this.currentSession.getPages() : NO_PAGES;
        if (page == this.appenderTypeWizardPage) {
            return null;
        }
        int i = sessionPages.length - 1;
        while (i >= 0) {
            if (page == sessionPages[i]) {
                if (i - 1 >= 0) {
                    return sessionPages[i - 1];
                }
                return this.appenderTypeWizardPage;
            }
            --i;
        }
        return null;
    }

    void initializeCurrentAppenderConfigurationSession(String id, String name, AppenderConfigurationWizardAdapter wizardAdapter) {
        Preconditions.checkState((wizardAdapter != null ? 1 : 0) != 0, (String)"No adapter available for editing appenders of type '%s'!", (Object[])new Object[]{id});
        AppenderConfigurationWizardSession session = this.findExistingSessionOrCreateNew(id, name);
        if (session == this.currentSession) {
            return;
        }
        if (session.getAppender() == null) {
            wizardAdapter.initializeAppender(session, this.existingAppender);
        }
        if (session.getPages() == null) {
            IWizardPage[] pages;
            IWizardPage[] iWizardPageArray = pages = wizardAdapter != null ? wizardAdapter.createPages(session) : NO_PAGES;
            if (pages != null) {
                session.setPages(pages);
                IWizardPage[] iWizardPageArray2 = pages;
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    IWizardPage page = iWizardPageArray2[n2];
                    this.addPage(page);
                    ++n2;
                }
            } else {
                LOG.debug("No pages returned for appender type {} (adapter {})", (Object)id, (Object)wizardAdapter);
                session.setPages(NO_PAGES);
            }
        }
        this.currentSession = session;
        if (this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    public boolean performFinish() {
        try {
            this.getAppender().setName(this.appenderTypeWizardPage.getAppenderName());
            return true;
        }
        catch (AssertionError | Exception | LinkageError e) {
            LOG.debug("Error writing appender. ", (Throwable)e);
            NonBlockingMessageDialogs.openError((Shell)this.getShell(), (String)"Error Updating Appender", (String)("Unable to update appender. " + ((Throwable)e).getMessage()), null);
            return false;
        }
    }
}

