/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;

public class EISMappedRecord
extends AbstractRecord {
    protected Map record;
    protected EISAccessor accessor;

    public EISMappedRecord(Map record, EISAccessor accessor) {
        this.setRecord(record);
        this.setAccessor(accessor);
    }

    public Vector getFields() {
        return new Vector(this.getRecord().keySet());
    }

    @Override
    public Vector getValues() {
        return new Vector(this.getRecord().values());
    }

    @Override
    public Set keySet() {
        Set keys = this.getRecord().keySet();
        if (keys == null) {
            return new HashSet(1);
        }
        return keys;
    }

    @Override
    public Collection values() {
        return this.getRecord().values();
    }

    @Override
    public int size() {
        return this.getRecord().size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void clear() {
        this.getRecord().clear();
    }

    @Override
    public Object get(String key) {
        return this.getRecord().get(key);
    }

    @Override
    public Object get(DatabaseField field) {
        Vector<EISMappedRecord> value = this.get(field.getName());
        if (value instanceof Map) {
            Vector<EISMappedRecord> nestedRows = new Vector<EISMappedRecord>(1);
            nestedRows.add(new EISMappedRecord((Map)((Object)value), this.getAccessor()));
            value = nestedRows;
        } else if (value instanceof List) {
            List values = value;
            Vector<EISMappedRecord> nestedValues = new Vector<EISMappedRecord>(values.size());
            int index = 0;
            while (index < values.size()) {
                Object nestedValue = values.get(index);
                if (nestedValue instanceof Map) {
                    nestedValues.add(new EISMappedRecord((Map)values.get(index), this.getAccessor()));
                } else {
                    nestedValues.add((EISMappedRecord)nestedValue);
                }
                ++index;
            }
            value = nestedValues;
        }
        return value;
    }

    @Override
    public boolean containsKey(String fieldName) {
        return this.get(fieldName) != null;
    }

    @Override
    public boolean containsKey(DatabaseField key) {
        return this.get(key) != null;
    }

    public Map getRecord() {
        return this.record;
    }

    public void setRecord(Map record) {
        this.record = record;
    }

    public EISAccessor getAccessor() {
        return this.accessor;
    }

    public void setAccessor(EISAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(Helper.getShortClassName(this.getClass()));
        writer.write("(");
        for (Object key : this.keySet()) {
            writer.write(Helper.cr());
            writer.write("\t");
            writer.write(String.valueOf(key));
            writer.write(" => ");
            writer.write(String.valueOf(this.get(key)));
        }
        writer.write(")");
        return writer.toString();
    }
}

