/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.jersey.core.osgi;


/**
 * Utility class to deal with OSGi runtime specific behavior. This is mainly to
 * handle META-INF/services lookup and generic/application class lookup issue in
 * OSGi. When OSGi runtime is detected by the
 * {@link com.sun.jersey.core.reflection.ReflectionHelper} class, an instance of
 * OsgiRegistry is created and associated with given OSGi BundleContext.
 * META-INF/services entries are then being accessed via the OSGi Bundle API as
 * direct ClassLoader#getResource() method invocation does not work in this case
 * within OSGi.
 * 
 * @author Jakub Podlesak (jakub.podlesak at oracle.com)
 * @author Michal Gajdos (michal.gajdos at oracle.com)
 */
public final class OsgiRegistry {

	/**
	 * Returns an {@code OsgiRegistry} instance. Call this method only if sure
	 * that the application is running in OSGi environment, otherwise a call to
	 * this method can lead to an {@link ClassNotFoundException}.
	 * 
	 * @return an {@code OsgiRegistry} instance.
	 */
	public static synchronized OsgiRegistry getInstance() {
		return null;
	}

	/**
	 * Get the Class from the class name.
	 * <p>
	 * The context class loader will be utilized if accessible and non-null.
	 * Otherwise the defining class loader of this class will be utilized.
	 * 
	 * @param className
	 *            the class name.
	 * @return the Class, otherwise null if the class cannot be found.
	 * @throws ClassNotFoundException
	 *             if the class cannot be found.
	 */
	public Class<?> classForNameWithException(final String className) throws ClassNotFoundException {
		throw new ClassNotFoundException(className);
	}
}