/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.internal;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.http.internal.EditPropertyDialog;
import org.eclipse.gyrex.admin.ui.http.internal.HttpUiActivator;
import org.eclipse.gyrex.admin.ui.http.internal.HttpUiAdapter;
import org.eclipse.gyrex.admin.ui.http.internal.MountApplicationDialog;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingStatusDialog;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.ComboDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.definitions.ContextDefinition;
import org.eclipse.gyrex.context.internal.ContextActivator;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.http.internal.HttpActivator;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationManager;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistration;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditApplicationDialog
extends NonBlockingStatusDialog {
    private static final long serialVersionUID = 1L;
    private final StringDialogField idField = new StringDialogField();
    private final ComboDialogField providerField = new ComboDialogField(12);
    private final Map<String, String> providerItemToIdMap = new HashMap<String, String>();
    private final StringDialogField contextPathField = new StringDialogField();
    private final ListDialogField propertiesField = new ListDialogField(new IListAdapter(){

        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    EditApplicationDialog.this.addNewProperty();
                    break;
                }
                case 1: {
                    EditApplicationDialog.this.editSelectedProperty();
                }
            }
        }

        public void doubleClicked(ListDialogField field) {
            EditApplicationDialog.this.editSelectedProperty();
        }

        public void selectionChanged(ListDialogField field) {
        }
    }, new String[]{"Add...", "Edit...", "Remove"}, (ILabelProvider)new PropertiesFieldLabelProvider()){

        protected int getListStyle() {
            return 68356;
        }
    };
    private final ListDialogField mountsField;
    private final ApplicationManager applicationManager;
    private final SortedMap<String, String> applicationProperties;
    private final ApplicationRegistration applicationRegistration;

    public EditApplicationDialog(Shell parent, ApplicationManager applicationManager, ApplicationRegistration applicationRegistration) {
        super(parent);
        this.propertiesField.setRemoveButtonIndex(2);
        this.propertiesField.setTableColumns(new ListDialogField.ColumnsDescription(new String[]{"Key", "Value"}, true));
        this.mountsField = new ListDialogField(new IListAdapter(){

            public void customButtonPressed(ListDialogField field, int index) {
                switch (index) {
                    case 0: {
                        EditApplicationDialog.this.addNewMount();
                    }
                }
            }

            public void doubleClicked(ListDialogField field) {
                EditApplicationDialog.this.editSelectedProperty();
            }

            public void selectionChanged(ListDialogField field) {
            }
        }, new String[]{"Add...", "Remove"}, (ILabelProvider)new LabelProvider());
        this.mountsField.setRemoveButtonIndex(1);
        this.mountsField.setViewerComparator(new ViewerComparator((Comparator)Collator.getInstance(Locale.US)));
        this.applicationProperties = new TreeMap<String, String>();
        this.applicationManager = applicationManager;
        this.applicationRegistration = applicationRegistration;
        this.setTitle(applicationRegistration == null ? "New Application" : "Edit Application");
        this.setShellStyle(67696);
    }

    void addNewMount() {
        final MountApplicationDialog dialog = new MountApplicationDialog(this.getParentShell());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    EditApplicationDialog.this.mountsField.addElement((Object)dialog.getUrl().toExternalForm());
                }
            }
        });
    }

    void addNewProperty() {
        final EditPropertyDialog dialog = new EditPropertyDialog(this.getParentShell(), null, null);
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    EditApplicationDialog.this.applicationProperties.put(dialog.getKey(), dialog.getValue());
                    EditApplicationDialog.this.refreshProperties();
                }
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.idField.setLabelText("Id");
        this.contextPathField.setLabelText("Context");
        this.providerField.setLabelText("Provider");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                EditApplicationDialog.this.validate();
            }
        };
        this.idField.setDialogFieldListener(validateListener);
        this.contextPathField.setDialogFieldListener(validateListener);
        this.providerField.setDialogFieldListener(validateListener);
        this.providerItemToIdMap.clear();
        TreeSet<String> providerItems = new TreeSet<String>();
        Collection providers = HttpActivator.getInstance().getProviderRegistry().getRegisteredProviders().values();
        for (ApplicationProviderRegistration registration : providers) {
            String label = HttpUiAdapter.getLabel(registration);
            this.providerItemToIdMap.put(label, registration.getProviderId());
            providerItems.add(label);
        }
        this.providerField.setItems(providerItems.toArray(new String[providerItems.size()]));
        this.contextPathField.setContentProposalProcessor(new IContentProposalProvider(){
            private static final long serialVersionUID = 1L;

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<ContentProposal> resultList = new ArrayList<ContentProposal>();
                String patternString = StringUtils.trimToNull((String)StringUtils.substring((String)contents, (int)0, (int)position));
                List contexts = ContextActivator.getInstance().getContextRegistryImpl().getDefinedContexts();
                for (ContextDefinition contextDefinition : contexts) {
                    if (patternString != null && !StringUtils.contains((String)contextDefinition.getPath().toString(), (String)patternString)) continue;
                    resultList.add(new ContentProposal(contextDefinition.getPath().toString(), contextDefinition.toString()));
                }
                return resultList.toArray(new IContentProposal[resultList.size()]);
            }
        });
        this.propertiesField.setLabelText("Properties");
        this.mountsField.setLabelText("Mounts");
        Text warning = new Text(composite, 72);
        warning.setText("Warning: this dialog is ugly. Please help us improve the UI. Any mockups and/or patches are very much appreciated!");
        warning.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.idField, this.providerField, this.contextPathField, new Separator(), this.propertiesField, this.mountsField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.idField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.providerField.getComboControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.contextPathField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.propertiesField.getListControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.mountsField.getListControl(null));
        if (this.applicationRegistration != null) {
            this.idField.setText(this.applicationRegistration.getApplicationId());
            this.idField.setEnabled(false);
            this.contextPathField.setText(this.applicationRegistration.getContext().getContextPath().toString());
            this.contextPathField.setEnabled(false);
            for (Map.Entry<String, String> e : this.providerItemToIdMap.entrySet()) {
                if (!e.getValue().equals(this.applicationRegistration.getProviderId())) continue;
                this.providerField.selectItem(e.getKey());
            }
            this.providerField.setEnabled(false);
            this.applicationProperties.putAll(this.applicationRegistration.getInitProperties());
            this.mountsField.setElements((Collection)this.applicationManager.getMounts(this.applicationRegistration.getApplicationId()));
        }
        this.refreshProperties();
        GridLayout masterLayout = (GridLayout)composite.getLayout();
        masterLayout.marginWidth = 5;
        masterLayout.marginHeight = 5;
        LayoutUtil.setHorizontalSpan((Control)warning, (int)masterLayout.numColumns);
        return composite;
    }

    void editSelectedProperty() {
        List selectedElements = this.propertiesField.getSelectedElements();
        if (selectedElements.isEmpty()) {
            return;
        }
        String[] elem = (String[])selectedElements.get(0);
        final EditPropertyDialog dialog = new EditPropertyDialog(this.getParentShell(), elem[0], elem[1]);
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    EditApplicationDialog.this.applicationProperties.put(dialog.getKey(), dialog.getValue());
                    EditApplicationDialog.this.refreshProperties();
                }
            }
        });
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        try {
            this.applicationProperties.clear();
            for (Object property : this.propertiesField.getElements()) {
                this.applicationProperties.put(((String[])property)[0], ((String[])property)[1]);
            }
            if (this.applicationRegistration == null) {
                String id = this.idField.getText();
                String providerId = this.providerItemToIdMap.get(this.providerField.getText());
                String contextPath = this.contextPathField.getText();
                IRuntimeContext context = ((IRuntimeContextRegistry)HttpUiActivator.getInstance().getService(IRuntimeContextRegistry.class)).get(new Path(contextPath).makeAbsolute().addTrailingSeparator());
                this.applicationManager.register(id, providerId, context, this.applicationProperties);
            } else {
                this.applicationManager.setProperties(this.applicationRegistration.getApplicationId(), this.applicationProperties);
            }
            List applicationMounts = this.mountsField.getElements();
            ArrayList existingMounts = this.applicationRegistration != null ? this.applicationManager.getMounts(this.applicationRegistration.getApplicationId()) : new ArrayList(1);
            for (String url : existingMounts) {
                if (applicationMounts.contains(url)) continue;
                this.applicationManager.unmount(url);
            }
            for (String url : applicationMounts) {
                if (existingMounts.contains(url)) continue;
                this.applicationManager.mount(url, this.applicationRegistration != null ? this.applicationRegistration.getApplicationId() : this.idField.getText());
            }
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)this.getParentShell(), (String)"Error", (String)"An error occured saving the application.", (IStatus)this.getStatus());
        }
        super.okPressed();
    }

    private void refreshProperties() {
        ArrayList<String[]> elements = new ArrayList<String[]>(this.applicationProperties.size());
        for (Map.Entry<String, String> entry : this.applicationProperties.entrySet()) {
            elements.add(new String[]{entry.getKey(), entry.getValue()});
        }
        this.propertiesField.setElements(elements);
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.http", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.http", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.http", message));
    }

    void validate() {
        String id = this.idField.getText();
        if (StringUtils.isBlank((String)id)) {
            this.setInfo("Please enter an id.");
            return;
        }
        if (!IdHelper.isValidId((String)id)) {
            this.setError("The entered id is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.");
            return;
        }
        String providerLabel = this.providerField.getText();
        if (StringUtils.isBlank((String)providerLabel)) {
            this.setInfo("Please select a provider.");
            return;
        }
        String path = this.contextPathField.getText();
        if (StringUtils.isBlank((String)path)) {
            this.setInfo("Please enter a context path.");
            return;
        }
        if (!Path.EMPTY.isValidPath(path)) {
            this.setError("The entered context path is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_' and '/' as separator.");
            return;
        }
        IRuntimeContextRegistry registry = (IRuntimeContextRegistry)HttpUiActivator.getInstance().getService(IRuntimeContextRegistry.class);
        IRuntimeContext context = registry.get((IPath)new Path(path));
        if (context == null) {
            this.setError("The context is not defined!");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    private static final class PropertiesFieldLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final long serialVersionUID = 1L;

        private PropertiesFieldLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String[]) {
                return ((String[])element)[columnIndex];
            }
            return this.getText(element);
        }
    }
}

