/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal;

import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.http.internal.BundleFinder;
import org.eclipse.gyrex.http.internal.HttpDebug;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class HttpActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.http";
    public static final String TYPE_WEB = "org.eclipse.gyrex.http.default";
    private static HttpActivator sharedInstance;
    private volatile ApplicationProviderRegistry providerRegistry;

    public static HttpActivator getInstance() throws IllegalStateException {
        HttpActivator instance = sharedInstance;
        if (instance == null) {
            throw new IllegalStateException("Gyrex HTTP Core has not been started.");
        }
        return instance;
    }

    public static String getVersion() {
        try {
            return HttpActivator.getInstance().getBundleVersion().toString();
        }
        catch (RuntimeException e) {
            return Version.emptyVersion.toString();
        }
    }

    public HttpActivator() {
        super(SYMBOLIC_NAME);
    }

    protected synchronized void doStart(BundleContext context) throws Exception {
        sharedInstance = this;
        this.providerRegistry = new ApplicationProviderRegistry(context);
        this.providerRegistry.open();
    }

    protected synchronized void doStop(BundleContext context) throws Exception {
        sharedInstance = null;
        this.providerRegistry.close();
        this.providerRegistry = null;
    }

    public Bundle getCallingBundle() {
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            return null;
        }
        return new BundleFinder(bundle).getCallingBundle();
    }

    protected Class getDebugOptions() {
        return HttpDebug.class;
    }

    public ApplicationProviderRegistry getProviderRegistry() {
        ApplicationProviderRegistry registry = this.providerRegistry;
        if (registry == null) {
            throw this.createBundleInactiveException();
        }
        return registry;
    }
}

