/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.logback.config.model;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.logback.config.model.Appender;
import org.eclipse.gyrex.logback.config.model.LobackConfigElement;
import org.eclipse.gyrex.logback.config.model.Logger;

public final class LogbackConfig
extends LobackConfigElement {
    private final List<Appender> appenders = new ArrayList<Appender>();
    private final List<Logger> loggers = new ArrayList<Logger>();
    private boolean shortenStackTraces;
    private Level defaultLevel;
    private List<String> defaultAppenders;

    static void writeProperty(XMLStreamWriter writer, String name, String value) throws XMLStreamException {
        writer.writeEmptyElement("property");
        writer.writeAttribute("name", name);
        writer.writeAttribute("value", value);
    }

    public void addAppender(Appender appender) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)appender.getName()), (Object)"appender name must not be blank");
        Preconditions.checkArgument((this.getAppender(appender.getName()) == null ? 1 : 0) != 0, (String)"Duplicate appender name '%s'!", (Object[])new Object[]{appender.getName()});
        this.appenders.add(appender);
    }

    private String addExceptionPattern(String pattern) {
        if (this.isShortenStackTraces()) {
            return String.valueOf(pattern) + "%rootException{6}";
        }
        return String.valueOf(pattern) + "%rootException";
    }

    public void addLogger(Logger logger) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)logger.getName()), (Object)"logger name must not be blank");
        Preconditions.checkArgument((this.getAppender(logger.getName()) == null ? 1 : 0) != 0, (String)"Duplicate logger name '%s'!", (Object[])new Object[]{logger.getName()});
        this.loggers.add(logger);
    }

    public Appender getAppender(String name) {
        for (Appender a : this.getAppenders()) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public List<Appender> getAppenders() {
        return Collections.unmodifiableList(this.appenders);
    }

    public List<String> getDefaultAppenders() {
        if (this.defaultAppenders == null) {
            this.defaultAppenders = new ArrayList<String>();
        }
        return this.defaultAppenders;
    }

    public Level getDefaultLevel() {
        if (this.defaultLevel == null) {
            return Level.INFO;
        }
        return this.defaultLevel;
    }

    public Logger getLogger(String name) {
        for (Logger l : this.getLoggers()) {
            if (!name.equals(l.getName())) continue;
            return l;
        }
        return null;
    }

    public List<Logger> getLoggers() {
        return Collections.unmodifiableList(this.loggers);
    }

    private String getLongPattern() {
        return this.addExceptionPattern("%date{ISO8601} [%thread.%property{HOSTNAME}] %-5level %logger{36} %mdc{gyrex.contextPath, '[CTX:', '] '}%mdc{gyrex.applicationId, '[APP:', '] '}%mdc{gyrex.jobId, '[JOB:', '] '}- %msg%n");
    }

    private String getShortPattern() {
        return this.addExceptionPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
    }

    public boolean isShortenStackTraces() {
        return this.shortenStackTraces;
    }

    public void removeAppender(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"appender name must not be blank");
        Appender appender = this.getAppender(name);
        if (appender != null) {
            this.appenders.remove(appender);
        }
    }

    public void removeLogger(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"logger name must not be blank");
        Logger logger = this.getLogger(name);
        if (logger != null) {
            this.loggers.remove(logger);
        }
    }

    public void setDefaultAppenders(List<String> defaultAppenders) {
        this.defaultAppenders = defaultAppenders;
    }

    public void setDefaultLevel(Level defaultLevel) {
        this.defaultLevel = defaultLevel;
    }

    public void setShortenStackTraces(boolean shortenStackTraces) {
        this.shortenStackTraces = shortenStackTraces;
    }

    @Override
    public void toXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument();
        writer.writeStartElement("configuration");
        writer.writeAttribute("scan", "true");
        writer.writeAttribute("scanPeriod", "2 minutes");
        this.writeCommonProperties(writer);
        this.writeJulLevelChangePropagator(writer);
        for (Appender appender : this.getAppenders()) {
            appender.toXml(writer);
        }
        for (Logger logger : this.getLoggers()) {
            logger.toXml(writer);
        }
        this.writeRootLogger(writer);
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private void writeCommonProperties(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeComment("common properties");
        LogbackConfig.writeProperty(writer, "BASE_PATH", "${gyrex.instance.area.logs:-logs}");
        LogbackConfig.writeProperty(writer, "PATTERN_SHORT", this.getShortPattern());
        LogbackConfig.writeProperty(writer, "PATTERN_LONG", this.getLongPattern());
    }

    private void writeJulLevelChangePropagator(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeComment("propagate log level changes to JUL");
        writer.writeStartElement("contextListener");
        writer.writeAttribute("class", LevelChangePropagator.class.getName());
        writer.writeStartElement("resetJUL");
        writer.writeCData("true");
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void writeRootLogger(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("root");
        writer.writeAttribute("level", this.getDefaultLevel().toString());
        for (String appenderRef : this.getDefaultAppenders()) {
            writer.writeEmptyElement("appender-ref");
            writer.writeAttribute("ref", appenderRef);
        }
        writer.writeEndElement();
    }
}

