/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.logback.config.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.logback.config.model.Appender;
import org.osgi.service.prefs.Preferences;

public abstract class AppenderProvider
extends PlatformObject {
    public static final String SERVICE_NAME = AppenderProvider.class.getName();
    private final List<String> providedTypeIds;

    protected AppenderProvider(String ... providedTypeIds) {
        if (providedTypeIds == null || providedTypeIds.length == 0) {
            throw new IllegalArgumentException("appender types must not be null or empty");
        }
        this.providedTypeIds = new ArrayList<String>(providedTypeIds.length);
        String[] stringArray = providedTypeIds;
        int n = providedTypeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!IdHelper.isValidId((String)id)) {
                throw new IllegalArgumentException(String.format("type id \"%s\" is invalid; valid chars are US-ASCII a-z / A-Z / 0-9 / '.' / '-' / '_'", id));
            }
            this.providedTypeIds.add(id);
            ++n2;
        }
    }

    public abstract void configureAppender(Appender var1, Preferences var2) throws Exception;

    public abstract Appender createAppender(String var1) throws Exception;

    public String getName(String typeId) {
        return null;
    }

    public final Collection<String> getProvidedTypeIds() {
        return Collections.unmodifiableCollection(this.providedTypeIds);
    }

    public final String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " [" + StringUtils.join(this.providedTypeIds, (char)',') + "]";
    }

    public abstract void writeAppenderConfiguration(Appender var1, Preferences var2) throws Exception;
}

