/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.internal.services;

import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.gyrex.common.internal.services.IServiceProxyDisposalListener;
import org.eclipse.gyrex.common.internal.services.ServiceProxy;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.osgi.framework.BundleContext;

public class ServiceProxyPool {
    private final ConcurrentHashMap<String, ServiceProxy<?>> trackedServices = new ConcurrentHashMap();
    private volatile BundleContext bundleContext;

    public ServiceProxyPool(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.bundleContext = null;
        ConcurrentHashMap<String, ServiceProxy<?>> concurrentHashMap = this.trackedServices;
        synchronized (concurrentHashMap) {
            for (ServiceProxy<?> serviceProxy : this.trackedServices.values()) {
                serviceProxy.dispose();
            }
            this.trackedServices.clear();
        }
    }

    public BundleContext getBundleContext() {
        BundleContext context = this.bundleContext;
        if (context == null) {
            throw new IllegalStateException("disposed");
        }
        return context;
    }

    private <T> String getKey(Class<T> serviceInterface, String filter) {
        if (filter != null) {
            return serviceInterface.getName().intern().concat(filter);
        }
        return serviceInterface.getName().intern();
    }

    public <T> IServiceProxy<T> getOrCreate(Class<T> serviceInterface) {
        return this.getOrCreate(serviceInterface, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> IServiceProxy<T> getOrCreate(Class<T> serviceInterface, String filter) {
        this.getBundleContext();
        String key = this.getKey(serviceInterface, filter);
        ServiceProxy<Object> proxy = this.trackedServices.get(key);
        if (proxy == null) {
            ConcurrentHashMap<String, ServiceProxy<?>> concurrentHashMap = this.trackedServices;
            synchronized (concurrentHashMap) {
                proxy = this.trackedServices.get(key);
                if (proxy == null) {
                    proxy = new ServiceProxy<T>(this.getBundleContext(), serviceInterface, filter);
                    proxy.addDisposalListener(new RemoveOnDisposalListener(key));
                    this.trackedServices.put(key, proxy);
                }
            }
        }
        return proxy;
    }

    private final class RemoveOnDisposalListener
    implements IServiceProxyDisposalListener {
        private final String key;

        private RemoveOnDisposalListener(String key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disposed(IServiceProxy<?> proxy) {
            ConcurrentHashMap concurrentHashMap = ServiceProxyPool.this.trackedServices;
            synchronized (concurrentHashMap) {
                ServiceProxyPool.this.trackedServices.remove(this.key);
            }
        }
    }
}

