/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal.commonapenders;

import org.eclipse.gyrex.admin.ui.logback.configuration.wizard.AppenderConfigurationWizardAdapter;
import org.eclipse.gyrex.admin.ui.logback.configuration.wizard.AppenderConfigurationWizardSession;
import org.eclipse.gyrex.admin.ui.logback.internal.commonapenders.AppenderThresholdWizardPage;
import org.eclipse.gyrex.admin.ui.logback.internal.commonapenders.ConsoleAppenderWizardPage;
import org.eclipse.gyrex.admin.ui.logback.internal.commonapenders.FileAppenderWizardPage;
import org.eclipse.gyrex.logback.config.model.Appender;
import org.eclipse.gyrex.logback.config.model.ConsoleAppender;
import org.eclipse.gyrex.logback.config.model.FileAppender;
import org.eclipse.jface.wizard.IWizardPage;

public class CommonAppendersWizardAdapter
extends AppenderConfigurationWizardAdapter {
    @Override
    protected Appender createAppender(String typeId) throws IllegalArgumentException {
        switch (typeId) {
            case "console": {
                return new ConsoleAppender();
            }
            case "file": {
                return new FileAppender();
            }
        }
        throw new IllegalArgumentException("unsupported type: " + typeId);
    }

    @Override
    public IWizardPage[] createPages(AppenderConfigurationWizardSession session) {
        switch (session.getAppenderTypeId()) {
            case "console": {
                return new IWizardPage[]{new ConsoleAppenderWizardPage(session), new AppenderThresholdWizardPage(session)};
            }
            case "file": {
                return new IWizardPage[]{new FileAppenderWizardPage(session), new AppenderThresholdWizardPage(session)};
            }
        }
        return null;
    }

    @Override
    protected boolean isCompatibleAppender(String typeId, Appender appender) throws IllegalArgumentException {
        switch (typeId) {
            case "console": {
                return appender instanceof ConsoleAppender;
            }
            case "file": {
                return appender instanceof FileAppender;
            }
        }
        throw new IllegalArgumentException("unsupported type: " + typeId);
    }
}

