/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.scheduler;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.scheduler.ScheduleMetrics;
import org.eclipse.gyrex.jobs.internal.scheduler.Scheduler;
import org.eclipse.gyrex.jobs.internal.scheduler.SchedulingJob;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleManagerImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.eclipse.gyrex.jobs.schedules.IScheduleEntry;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.osgi.framework.ServiceRegistration;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.impl.SchedulerRepository;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schedule
implements IEclipsePreferences.IPreferenceChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(Schedule.class);
    private static final long DEFERRED_ACTIVATION_DELAY = 10000L;
    private final DeferredActivationJob deferredActivationJob = new DeferredActivationJob();
    private final String scheduleStoreStorageKey;
    private final ScheduleMetrics metrics;
    private ServiceRegistration<MetricSet> metricsRegistration;
    private ScheduleImpl scheduleData;
    private org.quartz.Scheduler quartzScheduler;

    public static String asQuartzCronExpression(String cronExpression) {
        return "0 " + cronExpression;
    }

    public Schedule(String scheduleStoreStorageKey, Scheduler scheduler) throws Exception {
        this.scheduleStoreStorageKey = scheduleStoreStorageKey;
        this.metrics = new ScheduleMetrics(scheduleStoreStorageKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void activateEngine() {
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Activating schedule {}...", (Object)this.scheduleStoreStorageKey);
        }
        if (this.quartzScheduler != null) {
            return;
        }
        try {
            SchedulerRepository repository;
            System.setProperty("org.terracotta.quartz.skipUpdateCheck", "true");
            DirectSchedulerFactory factory = DirectSchedulerFactory.getInstance();
            SimpleThreadPool threadPool = new SimpleThreadPool(1, 5);
            threadPool.setInstanceId(this.scheduleStoreStorageKey);
            threadPool.setInstanceName(this.scheduleStoreStorageKey);
            RAMJobStore jobStore = new RAMJobStore();
            SchedulerRepository schedulerRepository = repository = SchedulerRepository.getInstance();
            synchronized (schedulerRepository) {
                factory.createScheduler(this.scheduleStoreStorageKey, this.scheduleStoreStorageKey, (ThreadPool)threadPool, (JobStore)jobStore);
                this.quartzScheduler = factory.getScheduler(this.scheduleStoreStorageKey);
                if (this.quartzScheduler == null) {
                    this.quartzScheduler = repository.lookup(this.scheduleStoreStorageKey);
                }
            }
            if (this.quartzScheduler == null) {
                throw new SchedulerException("Unabled to retrieve created scheduler from Quartz SchedulerRepository. It looks like the creation failed but the Quartz framework did not report it as such!");
            }
            this.refreshSchedule();
            this.quartzScheduler.start();
            this.metrics.setStatus("QUARTZRUNNING", "Quartz schedule started successfully");
            LOG.info("Activated schedule {}.", (Object)this.getScheduleStoreStorageKey());
        }
        catch (SchedulerException e) {
            LOG.error("Unable to activate Quarz scheduler. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            this.metrics.error("error activating schedule", e);
            this.quietShutdown();
        }
    }

    synchronized void deactivateEngine() {
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Deactivating Quartz engine {}...", (Object)this.getScheduleStoreStorageKey());
        }
        this.quietShutdown();
        this.metrics.setStatus("DEACTIVATED", "schedule deactivated");
    }

    private ScheduleImpl ensureScheduleData(boolean forceReload) {
        if (this.scheduleData == null || forceReload) {
            try {
                this.scheduleData = ScheduleStore.load(this.scheduleStoreStorageKey, ScheduleManagerImpl.getExternalId(this.scheduleStoreStorageKey), true);
                return this.scheduleData;
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Unable to load schedule '%s'. %s", this.scheduleStoreStorageKey, e.getMessage()), e);
            }
        }
        return this.scheduleData;
    }

    public String getScheduleStoreStorageKey() {
        return this.scheduleStoreStorageKey;
    }

    synchronized boolean isActive() {
        try {
            return this.quartzScheduler != null && this.quartzScheduler.isStarted();
        }
        catch (SchedulerException e) {
            return false;
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        block10: {
            this.deferredActivationJob.cancel();
            if ("enabled".equals(event.getKey())) {
                boolean activate = StringUtils.equals((String)Boolean.toString(Boolean.TRUE), (String)((String)event.getNewValue()));
                try {
                    if (activate) {
                        this.deferredActivationJob.schedule(10000L);
                        break block10;
                    }
                    this.deactivateEngine();
                }
                catch (Exception e) {
                    if (activate) {
                        LOG.error("Error activating schedule '{}'. {}", new Object[]{event.getNode().name(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                    } else {
                        LOG.error("Error deactivating schedule '{}'. {}", new Object[]{event.getNode().name(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                    }
                    this.quietShutdown();
                }
            } else if (!this.isActive()) {
                try {
                    this.deferredActivationJob.schedule(10000L);
                }
                catch (Exception e) {
                    this.quietShutdown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void quietShutdown() {
        this.deferredActivationJob.cancel();
        SchedulerRepository repository = SchedulerRepository.getInstance();
        if (this.quartzScheduler == null) {
            SchedulerRepository schedulerRepository = repository;
            synchronized (schedulerRepository) {
                this.quartzScheduler = repository.lookup(this.scheduleStoreStorageKey);
            }
        }
        if (this.quartzScheduler != null) {
            block22: {
                try {
                    try {
                        boolean removed;
                        SchedulerRepository schedulerRepository = repository;
                        synchronized (schedulerRepository) {
                            removed = repository.remove(this.scheduleStoreStorageKey);
                        }
                        if (!removed) {
                            LOG.error("Quartz eninge for schedule {} could not be removed from the Quartz scheduler repository. Please monitor the process memory and scheduling closely for anomalies. A restart of the node may be necessary.", (Object)this.scheduleStoreStorageKey);
                        } else if (JobsDebug.schedulerEngine) {
                            LOG.debug("Successful removal of Quartz engine {} from scheduler repo.", (Object)this.scheduleStoreStorageKey);
                        }
                    }
                    catch (Exception exception) {
                        try {
                            this.quartzScheduler.shutdown();
                            this.metrics.setStatus("QUARTZSTOPPED", "quiet shutdown triggered");
                            LOG.info("Deactivated schedule {}.", (Object)this.scheduleStoreStorageKey);
                        }
                        catch (Exception exception2) {}
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.quartzScheduler.shutdown();
                        this.metrics.setStatus("QUARTZSTOPPED", "quiet shutdown triggered");
                        LOG.info("Deactivated schedule {}.", (Object)this.scheduleStoreStorageKey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    this.quartzScheduler.shutdown();
                    this.metrics.setStatus("QUARTZSTOPPED", "quiet shutdown triggered");
                    LOG.info("Deactivated schedule {}.", (Object)this.scheduleStoreStorageKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.quartzScheduler = null;
        }
    }

    private synchronized void refreshSchedule() throws SchedulerException {
        String[] jobGroupNames = this.quartzScheduler.getJobGroupNames();
        if (jobGroupNames != null) {
            String[] stringArray = jobGroupNames;
            int n = jobGroupNames.length;
            int n2 = 0;
            while (n2 < n) {
                Object groupName = stringArray[n2];
                String[] stringArray2 = this.quartzScheduler.getJobNames((String)groupName);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String jobName = stringArray2[n4];
                    if (JobsDebug.schedulerEngine) {
                        LOG.debug("Removing job {} from Quartz engine {}...", (Object)jobName, (Object)this.getScheduleStoreStorageKey());
                    }
                    this.quartzScheduler.deleteJob(jobName, (String)groupName);
                    ++n4;
                }
                ++n2;
            }
        }
        ScheduleImpl schedule = this.ensureScheduleData(false);
        List<IScheduleEntry> entries = schedule.getEntries();
        for (IScheduleEntry entry : entries) {
            String cronExpression;
            if ("invalid".equals(entry.getJobTypeId()) || StringUtils.isBlank((String)(cronExpression = entry.getCronExpression()))) continue;
            CronTrigger trigger = new CronTrigger(entry.getId());
            trigger.setTimeZone(schedule.getTimeZone());
            try {
                trigger.setCronExpression(Schedule.asQuartzCronExpression(cronExpression));
            }
            catch (ParseException e) {
                LOG.error("Unable to schedule entry {}. Invalid cron expression. {}", (Object)entry, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                continue;
            }
            Date firstFireTime = trigger.computeFirstFireTime(null);
            if (firstFireTime == null) {
                if (!JobsDebug.schedulerEngine) continue;
                LOG.debug("Ignoring job {} since it won't be triggered anymore.", (Object)entry);
                continue;
            }
            JobDetail detail = new JobDetail(entry.getId(), SchedulingJob.class);
            SchedulingJob.populateJobDataMap(detail.getJobDataMap(), entry, schedule);
            if (JobsDebug.schedulerEngine) {
                LOG.debug("Adding job {} to Quartz engine {}...", (Object)entry, (Object)this.getScheduleStoreStorageKey());
            }
            this.quartzScheduler.scheduleJob(detail, (Trigger)trigger);
        }
    }

    public void start() throws Exception {
        ScheduleImpl schedule;
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Starting schedule {}...", (Object)this.getScheduleStoreStorageKey());
        }
        this.metricsRegistration = JobsActivator.registerMetrics(this.metrics);
        if (!ScheduleStore.getSchedulesNode().nodeExists(this.scheduleStoreStorageKey)) {
            this.metrics.setStatus("NOTFOUND", "not found during start");
            throw new IllegalStateException(String.format("Schedule '%s' not found", this.scheduleStoreStorageKey));
        }
        IEclipsePreferences node = (IEclipsePreferences)ScheduleStore.getSchedulesNode().node(this.scheduleStoreStorageKey);
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        try {
            schedule = this.ensureScheduleData(Boolean.TRUE);
        }
        catch (IllegalStateException e) {
            if (JobsDebug.schedulerEngine) {
                LOG.debug("Schedule {} will not be activated due to loading errors. It looks like its creation is still in progress.", (Object)this.scheduleStoreStorageKey, (Object)e);
            }
            this.metrics.setStatus("ERROR", "exception during start");
            this.metrics.error("loading error", e);
            return;
        }
        if (schedule.isEnabled()) {
            this.metrics.setStatus("ACTIVATING", "schedule started");
            this.activateEngine();
        } else {
            if (JobsDebug.schedulerEngine) {
                LOG.debug("Schedule {} is disabled.", (Object)this.getScheduleStoreStorageKey());
            }
            this.metrics.setStatus("DISABLED", "schedule is disabled");
        }
    }

    public void stop() {
        block21: {
            if (JobsDebug.schedulerEngine) {
                LOG.debug("Stopping schedule {}...", (Object)this.getScheduleStoreStorageKey());
            }
            this.deactivateEngine();
            try {
                try {
                    if (ScheduleStore.getSchedulesNode().nodeExists(this.scheduleStoreStorageKey)) {
                        IEclipsePreferences node = (IEclipsePreferences)ScheduleStore.getSchedulesNode().node(this.scheduleStoreStorageKey);
                        node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                    }
                }
                catch (Exception exception) {
                    ServiceRegistration<MetricSet> registration = this.metricsRegistration;
                    if (registration == null) break block21;
                    try {
                        try {
                            registration.unregister();
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.metricsRegistration = null;
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        this.metricsRegistration = null;
                        throw throwable;
                    }
                    this.metricsRegistration = null;
                    break block21;
                }
            }
            catch (Throwable throwable) {
                block24: {
                    ServiceRegistration<MetricSet> registration = this.metricsRegistration;
                    if (registration != null) {
                        try {
                            try {
                                registration.unregister();
                            }
                            catch (IllegalStateException illegalStateException) {
                                this.metricsRegistration = null;
                                break block24;
                            }
                        }
                        catch (Throwable throwable2) {
                            this.metricsRegistration = null;
                            throw throwable2;
                        }
                        this.metricsRegistration = null;
                    }
                }
                throw throwable;
            }
            ServiceRegistration<MetricSet> registration = this.metricsRegistration;
            if (registration != null) {
                try {
                    try {
                        registration.unregister();
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.metricsRegistration = null;
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    this.metricsRegistration = null;
                    throw throwable;
                }
                this.metricsRegistration = null;
            }
        }
        this.metrics.setStatus("STOPPED", "schedule stopped");
    }

    private class DeferredActivationJob
    extends Job {
        public DeferredActivationJob() {
            super("Deferred activation for schedule " + Schedule.this.getScheduleStoreStorageKey());
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ScheduleImpl schedule = Schedule.this.ensureScheduleData(Boolean.TRUE);
                if (schedule.isEnabled()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Schedule.this.activateEngine();
                } else {
                    Schedule.this.deactivateEngine();
                }
                return Status.OK_STATUS;
            }
            catch (RuntimeException e) {
                LOG.error("Error activating schedule {}: {}", new Object[]{Schedule.this.getScheduleStoreStorageKey(), e.getMessage(), e});
                Schedule.this.quietShutdown();
                return Status.CANCEL_STATUS;
            }
        }
    }
}

