/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.schedules;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.preferences.CloudScope;
import org.osgi.service.prefs.BackingStoreException;

public class ScheduleStore {
    public static ScheduleImpl create(String storageId, String scheduleId, IRuntimeContext context) throws BackingStoreException {
        IEclipsePreferences schedulesNode = ScheduleStore.getSchedulesNode();
        if (schedulesNode.nodeExists(storageId)) {
            throw new IllegalStateException(String.format("schedule '%s' already exists", scheduleId));
        }
        ScheduleImpl scheduleImpl = new ScheduleImpl(scheduleId, schedulesNode.node(storageId));
        scheduleImpl.setContextPath(context.getContextPath());
        scheduleImpl.save();
        return scheduleImpl;
    }

    public static void flush(String storageId, ScheduleImpl scheduleImpl) throws BackingStoreException {
        IEclipsePreferences schedulesNode = ScheduleStore.getSchedulesNode();
        if (!schedulesNode.nodeExists(storageId)) {
            throw new IllegalStateException(String.format("schedule node '%s' does not exist", scheduleImpl.getId()));
        }
        scheduleImpl.save();
    }

    public static String[] getSchedules() throws BackingStoreException {
        return ScheduleStore.getSchedulesNode().childrenNames();
    }

    public static IEclipsePreferences getSchedulesNode() {
        return (IEclipsePreferences)CloudScope.INSTANCE.getNode("org.eclipse.gyrex.jobs").node("schedules");
    }

    public static ScheduleImpl load(String storageId, String scheduleId, boolean failIfNotExist) throws BackingStoreException {
        IEclipsePreferences schedulesNode = ScheduleStore.getSchedulesNode();
        if (!schedulesNode.nodeExists(storageId)) {
            if (failIfNotExist) {
                throw new IllegalStateException(String.format("schedule '%s' does not exist", scheduleId));
            }
            return null;
        }
        return new ScheduleImpl(scheduleId, schedulesNode.node(storageId)).load();
    }

    public static void remove(String storageId, String scheduleId) throws BackingStoreException {
        IEclipsePreferences schedulesNode = ScheduleStore.getSchedulesNode();
        if (!schedulesNode.nodeExists(storageId)) {
            throw new IllegalStateException(String.format("schedule node '%s' does not exist", scheduleId));
        }
        schedulesNode.node(storageId).removeNode();
        schedulesNode.flush();
    }
}

