/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.gyrex.cloud.internal.preferences.ZooKeeperPreferencesService;
import org.eclipse.gyrex.common.lifecycle.IShutdownParticipant;
import org.eclipse.gyrex.preferences.internal.CloudPreferences;
import org.eclipse.gyrex.preferences.internal.InstanceBasedPreferences;
import org.eclipse.gyrex.preferences.internal.PreferencesActivator;
import org.eclipse.gyrex.preferences.internal.PreferencesDebug;
import org.eclipse.gyrex.server.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPreferencesScopeFactory
implements IScope,
IShutdownParticipant {
    private static final Logger LOG = LoggerFactory.getLogger(CloudPreferencesScopeFactory.class);
    private static final AtomicReference<CloudPreferences> rootCloudNode = new AtomicReference();
    private static final ZooKeeperPreferencesService service = new ZooKeeperPreferencesService("cloud");

    public IEclipsePreferences create(IEclipsePreferences parent, String name) {
        if (!"cloud".equals(name)) {
            LOG.error("Cloud preference factory called with illegal node name {} for parent {}.", new Object[]{name, parent.absolutePath(), new Exception("Call Stack")});
            throw new IllegalArgumentException("invalid node name");
        }
        if (Platform.inDevelopmentMode() && Boolean.getBoolean("gyrex.preferences.instancebased")) {
            LOG.info("Using instance based preferences as specified via system property!");
            return new InstanceBasedPreferences(parent, name);
        }
        CloudPreferences node = rootCloudNode.get();
        if (node != null) {
            if (PreferencesDebug.debug) {
                LOG.debug("Cloud preference factory called multiple times for name {} and parent {}.", new Object[]{name, parent.absolutePath(), new Exception("Call Stack")});
            }
            return node;
        }
        if (PreferencesDebug.debug) {
            LOG.debug("Creating ZooKeeper preferences '{}' (parent {})", (Object)name, (Object)parent);
        }
        rootCloudNode.compareAndSet(null, new CloudPreferences(parent, name, service));
        PreferencesActivator.getInstance().addShutdownParticipant(this);
        return (IEclipsePreferences)rootCloudNode.get();
    }

    public void shutdown() throws Exception {
        CloudPreferences node = rootCloudNode.get();
        if (node != null) {
            try {
                node.flush();
            }
            catch (Exception e) {
                LOG.debug("Failed to flush cloud preferences. Changes migt be lost. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        service.shutdown();
    }
}

