/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.pages.overview;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.admin.ui.internal.AdminUiActivator;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.pages.OverviewPageItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SystemStatus
extends OverviewPageItem {
    @Override
    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin(1, true));
        composite.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        AdminUiUtil.createHeading(composite, "System Status", 1);
        Label desc = new Label(composite, 64);
        desc.setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
        desc.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        IStatus status = AdminUiActivator.getInstance().getSystemStatus();
        if (!status.isOK()) {
            try {
                IStatus[] children;
                StringWriter writer = new StringWriter();
                IStatus[] iStatusArray = children = status.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    this.writeStatus(child, writer);
                    ++n2;
                }
                desc.setText(writer.toString());
            }
            catch (IOException e) {
                desc.setText(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        } else {
            desc.setText("System is running.");
        }
        return composite;
    }

    private String getStatusImage(IStatus status) {
        switch (status.getSeverity()) {
            case 4: 
            case 8: {
                return "/static/error.gif";
            }
            case 2: {
                return "/static/warning.gif";
            }
        }
        return "/static/information.gif";
    }

    final void writeEscaped(Writer writer, Object object) throws IOException {
        if (object == null) {
            return;
        }
        String string = object.toString();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    writer.write("&amp;");
                    break;
                }
                case '<': {
                    writer.write("&lt;");
                    break;
                }
                case '>': {
                    writer.write("&gt;");
                    break;
                }
                default: {
                    if (Character.isISOControl(c) && !Character.isWhitespace(c)) {
                        writer.write(63);
                        break;
                    }
                    writer.write(c);
                }
            }
            ++i;
        }
    }

    private void writeStatus(IStatus status, Writer writer) throws IOException, UnsupportedEncodingException {
        if (status.isOK()) {
            return;
        }
        String statusMessage = status.getMessage();
        if (status.isMultiStatus() && (statusMessage == null || statusMessage.trim().length() == 0)) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.writeStatusItem(child, writer, 0);
                ++n2;
            }
        } else {
            this.writeStatusItem(status, writer, 0);
        }
    }

    private void writeStatusItem(IStatus status, Writer writer, int identSize) throws IOException {
        if (status.isOK()) {
            return;
        }
        writer.write("<img src=\"" + this.getStatusImage(status) + "\" height=\"16\" width=\"16\"/>  ");
        this.writeEscaped(writer, status.getMessage());
        writer.write(" <small><code>(");
        this.writeEscaped(writer, status.getPlugin());
        writer.write(", code ");
        this.writeEscaped(writer, String.valueOf(status.getCode()));
        writer.write(")</code></small>");
        if (status.isMultiStatus()) {
            IStatus[] children;
            writer.write("<br/>");
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.writeStatusItem(child, writer, identSize + 4);
                ++n2;
            }
        }
    }
}

