/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields;

import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.rap.helper.SwtUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ComboDialogField
extends DialogField {
    private String fText = "";
    private int fSelectionIndex;
    private String[] fItems = new String[0];
    private Combo fComboControl;
    private ModifyListener fModifyListener;
    private final int fFlags;

    protected static GridData gridDataForCombo(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    public ComboDialogField(int flags) {
        this.fFlags = flags;
        this.fSelectionIndex = -1;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)ComboDialogField.gridDataForLabel(1));
        Combo combo = this.getComboControl(parent);
        combo.setLayoutData((Object)ComboDialogField.gridDataForCombo(nColumns - 1));
        return new Control[]{label, combo};
    }

    private void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fText = this.fComboControl.getText();
            this.fSelectionIndex = this.fComboControl.getSelectionIndex();
        }
        this.dialogFieldChanged();
    }

    private void doSelectionChanged(SelectionEvent e) {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fItems = this.fComboControl.getItems();
            this.fText = this.fComboControl.getText();
            this.fSelectionIndex = this.fComboControl.getSelectionIndex();
        }
        this.dialogFieldChanged();
    }

    public Combo getComboControl(Composite parent) {
        if (this.fComboControl == null) {
            this.assertCompositeNotNull(parent);
            this.fModifyListener = new ModifyListener(){
                private static final long serialVersionUID = 1L;

                public void modifyText(ModifyEvent e) {
                    ComboDialogField.this.doModifyText(e);
                }
            };
            SelectionListener selectionListener = new SelectionListener(){
                private static final long serialVersionUID = 1L;

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ComboDialogField.this.doSelectionChanged(e);
                }
            };
            this.fComboControl = new Combo(parent, this.fFlags);
            this.fComboControl.setItems(this.fItems);
            if (this.fSelectionIndex != -1) {
                this.fComboControl.select(this.fSelectionIndex);
            } else {
                this.fComboControl.setText(this.fText);
            }
            this.fComboControl.setFont(parent.getFont());
            SwtUtil.setDefaultVisibleItemCount((Combo)this.fComboControl);
            this.fComboControl.addModifyListener(this.fModifyListener);
            this.fComboControl.addSelectionListener(selectionListener);
            this.fComboControl.setEnabled(this.isEnabled());
        }
        return this.fComboControl;
    }

    public String[] getItems() {
        return this.fItems;
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public int getSelectionIndex() {
        return this.fSelectionIndex;
    }

    public String getText() {
        return this.fText;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.setTextWithoutUpdate(this.fText);
    }

    public boolean selectItem(int index) {
        boolean success = false;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.select(index);
            success = this.fComboControl.getSelectionIndex() == index;
        } else if (index >= 0 && index < this.fItems.length) {
            this.fText = this.fItems[index];
            this.fSelectionIndex = index;
            success = true;
        }
        if (success) {
            this.dialogFieldChanged();
        }
        return success;
    }

    public boolean selectItem(String name) {
        int i = 0;
        while (i < this.fItems.length) {
            if (this.fItems[i].equals(name)) {
                return this.selectItem(i);
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setFocus();
        }
        return true;
    }

    public void setItems(String[] items) {
        this.fItems = items;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setItems(items);
        }
        this.dialogFieldChanged();
    }

    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextWithoutUpdate(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.removeModifyListener(this.fModifyListener);
            this.fComboControl.setText(text);
            this.fComboControl.addModifyListener(this.fModifyListener);
        }
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setEnabled(this.isEnabled());
        }
    }
}

