/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.lang.reflect.Field;
import java.net.URL;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsUiImages;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobsUiActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.admin.ui.jobs";
    private static volatile JobsUiActivator instance;
    private static final String IMAGE_REGISTRY;
    private static final Logger LOG;

    static {
        IMAGE_REGISTRY = String.valueOf(JobsUiActivator.class.getName()) + "#imageRegistry";
        LOG = LoggerFactory.getLogger(JobsUiActivator.class);
    }

    public static JobsUiActivator getInstance() {
        JobsUiActivator activator = instance;
        if (activator == null) {
            throw new IllegalArgumentException("inactive");
        }
        return activator;
    }

    public JobsUiActivator() {
        super(SYMBOLIC_NAME);
    }

    private void createImageDescriptor(String id, ImageRegistry reg) {
        URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path("$nl$/icons/" + id), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(id, desc);
    }

    protected void doStart(BundleContext context) throws Exception {
        instance = this;
    }

    protected void doStop(BundleContext context) throws Exception {
        instance = null;
    }

    public ImageRegistry getImageRegistry() {
        ImageRegistry imageRegistry = (ImageRegistry)RWT.getUISession().getAttribute(IMAGE_REGISTRY);
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry(Display.getCurrent());
            this.initializeImageRegistry(imageRegistry);
            RWT.getUISession().setAttribute(IMAGE_REGISTRY, (Object)imageRegistry);
        }
        return imageRegistry;
    }

    private void initializeImageRegistry(ImageRegistry reg) {
        Field[] fields;
        Field[] fieldArray = fields = JobsUiImages.class.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().startsWith("IMG_")) {
                try {
                    this.createImageDescriptor((String)field.get(null), reg);
                }
                catch (Exception e) {
                    LOG.warn("Unable to initialize image ({}) in bundle {}. {}", new Object[]{field.getName(), SYMBOLIC_NAME, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                }
            }
            ++n2;
        }
    }
}

