/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal;

import java.util.List;
import org.eclipse.gyrex.admin.ui.logback.internal.AppenderReference;
import org.eclipse.gyrex.admin.ui.logback.internal.AppendersGroup;
import org.eclipse.gyrex.admin.ui.logback.internal.DefaultLogger;
import org.eclipse.gyrex.admin.ui.logback.internal.LoggersGroup;
import org.eclipse.gyrex.logback.config.model.Appender;
import org.eclipse.gyrex.logback.config.model.LogbackConfig;
import org.eclipse.gyrex.logback.config.model.Logger;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class LogbackConfigContentProvider
implements ITreeContentProvider {
    private static final long serialVersionUID = 1L;
    public static final Object[] NO_CHILDREN = new Object[0];
    private AppendersGroup appendersGroup;
    private LoggersGroup loggersGroup;
    private DefaultLogger defaultLogger;

    public void dispose() {
    }

    public Object[] getChildren(Object o) {
        if (o instanceof LogbackConfig) {
            return new Object[]{this.appendersGroup, this.loggersGroup, this.defaultLogger};
        }
        if (o == this.appendersGroup) {
            return this.appendersGroup.getAppenders().toArray();
        }
        if (o == this.loggersGroup) {
            return this.loggersGroup.getLoggers().toArray();
        }
        if (o == this.defaultLogger) {
            return this.toAppenderReferences(this.defaultLogger, this.defaultLogger.getAppenderReferences());
        }
        if (o instanceof Logger) {
            Logger logger = (Logger)o;
            return this.toAppenderReferences(logger, logger.getAppenderReferences());
        }
        return NO_CHILDREN;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof AppenderReference) {
            return ((AppenderReference)element).getParent();
        }
        if (element instanceof Logger) {
            return this.loggersGroup;
        }
        if (element instanceof Appender) {
            return this.appendersGroup;
        }
        if (element == this.appendersGroup || element == this.loggersGroup || element == this.defaultLogger) {
            return this.defaultLogger.getConfig();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof LogbackConfig) {
            LogbackConfig logbackConfig = (LogbackConfig)newInput;
            this.appendersGroup = new AppendersGroup(logbackConfig);
            this.loggersGroup = new LoggersGroup(logbackConfig);
            this.defaultLogger = new DefaultLogger(logbackConfig);
        }
    }

    private Object[] toAppenderReferences(Object parent, List<String> appenderReferences) {
        Object[] children = new Object[appenderReferences.size()];
        int i = 0;
        while (i < children.length) {
            children[i] = new AppenderReference(parent, appenderReferences.get(i));
            ++i;
        }
        return children;
    }
}

