/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.application;

import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.internal.AdminUiActivator;
import org.eclipse.gyrex.rap.application.RapApplicationEntryPoint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Version;

public class AdminApplication
extends RapApplicationEntryPoint
implements EntryPoint {
    private Image logo;

    public static Image getImage(Display display, String path) {
        ImageDescriptor imageDescriptor = AdminUiActivator.getImageDescriptor("img/" + path);
        return imageDescriptor.createImage((Device)display);
    }

    private static String getVersion() {
        Version version = AdminUiActivator.getInstance().getBundleVersion();
        StringBuilder resultBuffer = new StringBuilder(60);
        String buildId = AdminUiActivator.getInstance().getBundle().getBundleContext().getProperty("gyrex.buildId");
        if (StringUtils.isNotBlank((String)buildId)) {
            resultBuffer.append("(Gyrex ").append(buildId);
            String buildTimestamp = AdminUiActivator.getInstance().getBundle().getBundleContext().getProperty("gyrex.buildTimestamp");
            if (StringUtils.isNotBlank((String)buildTimestamp)) {
                resultBuffer.append(" Build ").append(buildTimestamp);
                resultBuffer.append(buildTimestamp);
            }
            resultBuffer.append(')');
        } else if (StringUtils.equals((String)version.getQualifier(), (String)"qualifier")) {
            resultBuffer.append("(Developer Build)");
        }
        return resultBuffer.toString();
    }

    protected String getFooterText() {
        return "Admin Console " + AdminApplication.getVersion();
    }

    protected Image getLogo() {
        if (this.logo != null) {
            return this.logo;
        }
        this.logo = AdminApplication.getImage(Display.getCurrent(), "gyrex/gyrex-juno.png");
        return this.logo;
    }
}

