/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.server.settings;

import org.eclipse.gyrex.server.settings.ValueConverter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ValueConverterTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void convertBooleans() throws Exception {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ValueConverter.convertToValueType((String)"true", Boolean.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ValueConverter.convertToValueType((String)"false", Boolean.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ValueConverter.convertToValueType((String)"", Boolean.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ValueConverter.convertToValueType((String)"kcsajbcia", Boolean.class));
    }

    @Test
    public void convertNumbers() throws Exception {
        Assert.assertEquals((Object)new Integer(1), (Object)ValueConverter.convertToValueType((String)"1", Integer.class));
        Assert.assertEquals((Object)new Long(1L), (Object)ValueConverter.convertToValueType((String)"1", Long.class));
        Assert.assertEquals((Object)new Double(1.2), (Object)ValueConverter.convertToValueType((String)"1.2", Double.class));
        Assert.assertEquals((Object)new Float(1.2f), (Object)ValueConverter.convertToValueType((String)"1.2", Float.class));
    }

    @Test
    public void convertStrings() throws Exception {
        Assert.assertEquals((Object)"blah", (Object)ValueConverter.convertToValueType((String)"blah", String.class));
    }

    @Test
    public void unparsableDouble_does_throw_IllegalArgumentException() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        ValueConverter.convertToValueType((String)"1s", Double.class);
    }

    @Test
    public void unparsableFloat_does_throw_IllegalArgumentException() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        ValueConverter.convertToValueType((String)"1s", Float.class);
    }

    @Test
    public void unparsableInteger_does_throw_IllegalArgumentException() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        ValueConverter.convertToValueType((String)"1s", Integer.class);
    }

    @Test
    public void unparsableLong_does_throw_IllegalArgumentException() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        ValueConverter.convertToValueType((String)"1s", Long.class);
    }
}

