/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.internal.console;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.boot.internal.BootActivator;
import org.eclipse.gyrex.common.console.Command;
import org.kohsuke.args4j.Argument;
import org.osgi.framework.Bundle;

public class FindCmd
extends Command {
    @Argument(index=0, usage="an optional bundle symbolic name filter string", required=false)
    String filter;

    public FindCmd() {
        super("searches bundles for possible debug options (requires .options file in bundle)");
    }

    protected void doExecute() throws Exception {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = BootActivator.getInstance().getContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if ((bundle.getState() & 3) == 0) {
                URL optionsEntry;
                String symbolicName = bundle.getSymbolicName();
                if ((this.filter == null || StringUtils.containsIgnoreCase((String)symbolicName, (String)this.filter)) && (optionsEntry = bundle.getEntry(".options")) != null) {
                    InputStream stream = optionsEntry.openStream();
                    try {
                        List lines = IOUtils.readLines((InputStream)stream);
                        StrBuilder string = new StrBuilder();
                        int padWidth = symbolicName.length() + 6;
                        string.appendPadding(padWidth, '-').appendNewLine();
                        string.append("   ").append(symbolicName).appendNewLine();
                        string.appendPadding(padWidth, '-').appendNewLine();
                        for (String line : lines) {
                            string.append("> ").appendln(line);
                        }
                        this.printf(string.toString(), new Object[0]);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                }
            }
            ++n2;
        }
    }
}

