/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.tests.internal;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.internal.GyrexContextHandle;
import org.eclipse.gyrex.context.internal.GyrexContextImpl;
import org.eclipse.gyrex.context.internal.IContextDisposalListener;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GyrexContextImplTest {
    private ContextRegistryImpl contextRegistry;

    @Before
    public void setUp() throws Exception {
        this.contextRegistry = new ContextRegistryImpl(){

            public GyrexContextHandle getHandle(IPath contextPath) {
                return new GyrexContextHandle(contextPath, (ContextRegistryImpl)this);
            }
        };
    }

    @After
    public void tearDown() throws Exception {
        this.contextRegistry = null;
    }

    @Test
    public void testDispose() {
        final GyrexContextImpl contextToTest = new GyrexContextImpl((IPath)new Path("/test"), this.contextRegistry);
        final boolean[] disposableDisposed = new boolean[1];
        IContextDisposalListener testableDisposal = new IContextDisposalListener(){

            public void contextDisposed(IRuntimeContext runtimeContext) {
                Assert.assertTrue((boolean)contextToTest.isDisposed());
                disposableDisposed[0] = true;
            }
        };
        contextToTest.addDisposable(testableDisposal);
        Assert.assertFalse((boolean)contextToTest.isDisposed());
        Assert.assertFalse((boolean)disposableDisposed[0]);
        contextToTest.dispose();
        Assert.assertTrue((boolean)contextToTest.isDisposed());
        Assert.assertTrue((boolean)disposableDisposed[0]);
    }
}

