/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.eventbus.internal;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.provider.di.ExtendedObjectResolver;
import org.eclipse.gyrex.eventbus.IEventBus;
import org.eclipse.gyrex.eventbus.IEventDeserializer;
import org.eclipse.gyrex.eventbus.IEventSerializer;
import org.eclipse.gyrex.eventbus.ITopic;
import org.eclipse.gyrex.eventbus.ITopicBuilder;
import org.eclipse.gyrex.eventbus.Topic;
import org.eclipse.gyrex.eventbus.internal.InvalidDeSerializer;

public class TopicInjectionResolver
extends ExtendedObjectResolver {
    private IEventBus eventBus;

    public Object get(Class<?> type, IRuntimeContext context, Annotation annotation) {
        Preconditions.checkState((boolean)ITopic.class.isAssignableFrom(type), (Object)"The @Topic qualifier must only be used for injecting ITopic instances.");
        Topic topic = (Topic)annotation;
        ITopicBuilder builder = this.eventBus.getTopic(topic.value());
        Class<Object>[] classArray = topic.deserializer();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<IEventDeserializer<?>> deserializer = classArray[n2];
            if (!InvalidDeSerializer.class.isAssignableFrom(deserializer)) {
                builder.addDeserializer((IEventDeserializer)context.getInjector().make(deserializer));
            }
            ++n2;
        }
        classArray = topic.serializer();
        n = classArray.length;
        n2 = 0;
        while (n2 < n) {
            Class<Object> serializer = classArray[n2];
            if (!InvalidDeSerializer.class.isAssignableFrom(serializer)) {
                builder.addSerializer((IEventSerializer)context.getInjector().make(serializer));
            }
            ++n2;
        }
        return builder.build();
    }

    public void setEventBus(IEventBus eventBus) {
        this.eventBus = eventBus;
    }
}

