/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal.application.manager;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.http.application.manager.ApplicationRegistrationException;
import org.eclipse.gyrex.http.application.manager.IApplicationManager;
import org.eclipse.gyrex.http.application.manager.MountConflictException;
import org.eclipse.gyrex.http.internal.HttpActivator;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;
import org.eclipse.gyrex.preferences.CloudScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ApplicationManager
implements IApplicationManager {
    public static final String NODE_URLS = "urls";
    public static final String NODE_APPLICATIONS = "applications";
    public static final String NODE_PROPERTIES = "properties";
    public static final String KEY_CONTEXT_PATH = "contextPath";
    public static final String KEY_PROVIDER_ID = "providerId";
    public static final String KEY_ACTIVE = "active";
    public static final boolean DEFAULT_ACTIVE = true;

    public static IEclipsePreferences getAppsNode() {
        return (IEclipsePreferences)CloudScope.INSTANCE.getNode("org.eclipse.gyrex.http").node(NODE_APPLICATIONS);
    }

    public static IEclipsePreferences getUrlsNode() {
        return (IEclipsePreferences)CloudScope.INSTANCE.getNode("org.eclipse.gyrex.http").node(NODE_URLS);
    }

    @Override
    public void activate(String applicationId) {
        this.checkApplicationId(applicationId);
        try {
            IEclipsePreferences node = ApplicationManager.getAppsNode();
            if (!node.nodeExists(applicationId)) {
                throw new IllegalStateException(String.format("Application '%s' does not exist", applicationId));
            }
            node.node(applicationId).putBoolean(KEY_ACTIVE, true);
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error activating application. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    private void checkApplicationId(String applicationId) throws IllegalArgumentException {
        if (!IdHelper.isValidId((String)applicationId)) {
            throw new IllegalArgumentException("invalid application id; please use only ascii chars a-z, 0-9, ., _ and/or -");
        }
    }

    @Override
    public void deactivate(String applicationId) {
        this.checkApplicationId(applicationId);
        try {
            IEclipsePreferences node = ApplicationManager.getAppsNode();
            if (!node.nodeExists(applicationId)) {
                throw new IllegalStateException(String.format("Application '%s' does not exist", applicationId));
            }
            node.node(applicationId).putBoolean(KEY_ACTIVE, false);
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error removing application registration info from the backend data store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    public ApplicationRegistration getApplicationRegistration(String applicationId) {
        try {
            Preferences appNode = ApplicationManager.getAppsNode().node(applicationId);
            if (!appNode.nodeExists("")) {
                throw new IllegalStateException(String.format("application %s does not exists", applicationId));
            }
            String providerId = appNode.get(KEY_PROVIDER_ID, null);
            if (StringUtils.isBlank((String)providerId)) {
                throw new IllegalStateException(String.format("application information %s contains invalid provider id %s", applicationId, String.valueOf(providerId)));
            }
            String contextPath = appNode.get(KEY_CONTEXT_PATH, null);
            if (StringUtils.isBlank((String)contextPath) || !Path.EMPTY.isValidPath(contextPath)) {
                throw new IllegalStateException(String.format("application information %s contains invalid context path %s", applicationId, String.valueOf(contextPath)));
            }
            IRuntimeContext context = ((IRuntimeContextRegistry)HttpActivator.getInstance().getService(IRuntimeContextRegistry.class)).get((IPath)new Path(contextPath));
            if (context == null) {
                throw new IllegalStateException(String.format("context %s does not exists", contextPath));
            }
            return new ApplicationRegistration(applicationId, providerId, context, this);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error reading application info for application %s. %s", applicationId, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    @Override
    public SortedSet<String> getMounts(String applicationId) throws IllegalArgumentException, IllegalStateException {
        block5: {
            this.checkApplicationId(applicationId);
            if (ApplicationManager.getAppsNode().nodeExists(applicationId)) break block5;
            return null;
        }
        try {
            String[] urls;
            IEclipsePreferences urlsNode = ApplicationManager.getUrlsNode();
            TreeSet<String> mounts = new TreeSet<String>();
            String[] stringArray = urls = urlsNode.keys();
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                String appId = urlsNode.get(url, "");
                if (appId.equals(applicationId)) {
                    mounts.add(url);
                }
                ++n2;
            }
            return mounts;
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error reading application info for application %s. %s", applicationId, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    @Override
    public Map<String, String> getProperties(String applicationId) throws IllegalArgumentException {
        block5: {
            this.checkApplicationId(applicationId);
            if (ApplicationManager.getAppsNode().nodeExists(applicationId)) break block5;
            return null;
        }
        try {
            Preferences appNode = ApplicationManager.getAppsNode().node(applicationId);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (appNode.nodeExists(NODE_PROPERTIES)) {
                String[] keys;
                Preferences propertiesNode = appNode.node(NODE_PROPERTIES);
                String[] stringArray = keys = propertiesNode.keys();
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    properties.put(key, propertiesNode.get(key, null));
                    ++n2;
                }
            }
            return properties;
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error reading application properties for application %s. %s", applicationId, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    public Collection<String> getRegisteredApplications() throws BackingStoreException {
        return Arrays.asList(ApplicationManager.getAppsNode().childrenNames());
    }

    public boolean isActive(String applicationId) {
        this.checkApplicationId(applicationId);
        try {
            IEclipsePreferences node = ApplicationManager.getAppsNode();
            if (!node.nodeExists(applicationId)) {
                throw new IllegalStateException(String.format("Application '%s' does not exist", applicationId));
            }
            return node.node(applicationId).getBoolean(KEY_ACTIVE, true);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error activating application. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public boolean isRegistered(String applicationId) throws IllegalArgumentException {
        this.checkApplicationId(applicationId);
        try {
            return ApplicationManager.getAppsNode().nodeExists(applicationId);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error checking application registration. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public void mount(String url, String applicationId) throws MountConflictException, MalformedURLException {
        URL parsedUrl = this.parseAndVerifyUrl(url);
        this.checkApplicationId(applicationId);
        try {
            IEclipsePreferences node = ApplicationManager.getAppsNode();
            if (!node.nodeExists(applicationId)) {
                throw new IllegalStateException(String.format("Application '%s' does not exist", applicationId));
            }
            String externalForm = parsedUrl.toExternalForm();
            IEclipsePreferences urlsNode = ApplicationManager.getUrlsNode();
            if (urlsNode.get(externalForm, null) != null) {
                throw new MountConflictException(url);
            }
            urlsNode.put(externalForm, applicationId);
            urlsNode.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error persisting application registration info to the backend data store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    private URL parseAndVerifyUrl(String url) throws MalformedURLException {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        URL parsedUrl = new URL(url);
        String protocol = parsedUrl.getProtocol();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new IllegalArgumentException("url '" + url + "' must start with 'http://' or 'https://'");
        }
        return parsedUrl;
    }

    @Override
    public void register(String applicationId, String providerId, IRuntimeContext context, Map<String, String> properties) throws ApplicationRegistrationException {
        this.checkApplicationId(applicationId);
        if (!IdHelper.isValidId((String)providerId)) {
            throw new IllegalArgumentException("invalid provider id; please use only ascii chars a-z, 0-9, ., _ and/or -");
        }
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        try {
            if (ApplicationManager.getAppsNode().nodeExists(applicationId)) {
                throw new ApplicationRegistrationException(applicationId);
            }
            Preferences appNode = ApplicationManager.getAppsNode().node(applicationId);
            appNode.put(KEY_PROVIDER_ID, providerId);
            appNode.put(KEY_CONTEXT_PATH, context.getContextPath().toString());
            if (properties != null) {
                Preferences propertiesNode = appNode.node(NODE_PROPERTIES);
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    propertiesNode.put(entry.getKey(), entry.getValue());
                }
            }
            ApplicationManager.getAppsNode().flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error persisting application registration info to the backend data store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public void setProperties(String applicationId, Map<String, String> properties) throws IllegalArgumentException, IllegalStateException {
        this.checkApplicationId(applicationId);
        try {
            if (ApplicationManager.getAppsNode().nodeExists(applicationId)) {
                throw new IllegalStateException(String.format("application %s does not exists", applicationId));
            }
            Preferences appNode = ApplicationManager.getAppsNode().node(applicationId);
            if (properties == null || properties.isEmpty()) {
                if (appNode.nodeExists(NODE_PROPERTIES)) {
                    appNode.node(NODE_PROPERTIES).removeNode();
                    appNode.flush();
                }
            } else {
                String[] keys;
                Preferences propertiesNode = appNode.node(NODE_PROPERTIES);
                for (String key : properties.keySet()) {
                    String value = properties.get(key);
                    if (StringUtils.isNotBlank((String)value)) {
                        propertiesNode.put(key, value);
                        continue;
                    }
                    propertiesNode.remove(key);
                }
                String[] stringArray = keys = propertiesNode.keys();
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    if (!properties.containsKey(key)) {
                        propertiesNode.remove(key);
                    }
                    ++n2;
                }
                appNode.flush();
            }
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error reading application properties for application %s. %s", applicationId, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    @Override
    public void unmount(String url) throws MalformedURLException, IllegalArgumentException, IllegalStateException {
        URL parsedUrl = this.parseAndVerifyUrl(url);
        try {
            String externalForm = parsedUrl.toExternalForm();
            IEclipsePreferences urlsNode = ApplicationManager.getUrlsNode();
            String applicationId = urlsNode.get(externalForm, null);
            if (applicationId == null) {
                throw new IllegalStateException("no application was mounted for url '" + externalForm + "' (submitted url was '" + url + "')");
            }
            urlsNode.remove(externalForm);
            urlsNode.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error persisting application registration info to the backend data store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public void unregister(String applicationId) {
        try {
            IEclipsePreferences node = ApplicationManager.getAppsNode();
            if (!node.nodeExists(applicationId)) {
                throw new IllegalStateException(String.format("Application '%s' does not exist", applicationId));
            }
            SortedSet<String> existingMounts = this.getMounts(applicationId);
            for (String url : existingMounts) {
                this.unmount(url);
            }
            node.node(applicationId).removeNode();
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error removing application registration info from the backend data store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Error removing application while unmounting urls. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }
}

