/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.commands;

import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.manager.JobManagerImpl;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class CancelJobCmd
extends Command {
    @Argument(index=0, usage="the path of the context the schedule will operate in", required=true, metaVar="CONTEXTPATH")
    String contextPath;
    @Argument(index=1, usage="job id filter string", required=true, metaVar="JOB-ID-FILTER")
    String searchString;
    @Option(name="-reset", usage="flag to force a reset of a job state (default is no)", required=false)
    boolean resetJobState;

    public CancelJobCmd() {
        super("<filterString> - cancels all matching jobs");
    }

    protected void doExecute() throws Exception {
        if (StringUtils.isBlank((String)this.searchString)) {
            this.printf("ERROR: please specify a job filter (use '*' to cancel all)", new Object[0]);
            return;
        }
        Path parsedContextPath = new Path(this.contextPath);
        IRuntimeContext context = ((IRuntimeContextRegistry)JobsActivator.getInstance().getService(IRuntimeContextRegistry.class)).get((IPath)parsedContextPath);
        if (context == null) {
            this.printf("Context '%s' not defined!", new Object[]{parsedContextPath});
            return;
        }
        IJobManager jobManager = (IJobManager)context.get(IJobManager.class);
        TreeSet<String> jobIds = new TreeSet<String>(jobManager.getJobs());
        if (!StringUtils.equals((String)this.searchString, (String)"*") && IdHelper.isValidId((String)this.searchString) && jobIds.contains(this.searchString)) {
            jobManager.cancelJob(this.searchString, "console");
            if (this.resetJobState) {
                ((JobManagerImpl)jobManager).setJobState(this.searchString, JobState.ABORTING, JobState.NONE, null, System.currentTimeMillis());
            }
            this.printf("Job %s canceled.", new Object[]{this.searchString});
            return;
        }
        for (String jobId : jobIds) {
            if (!StringUtils.equals((String)this.searchString, (String)"*") && !StringUtils.contains((String)jobId, (String)this.searchString)) continue;
            try {
                jobManager.cancelJob(jobId, "console");
                if (this.resetJobState) {
                    ((JobManagerImpl)jobManager).setJobState(jobId, JobState.ABORTING, JobState.NONE, null, System.currentTimeMillis());
                }
                this.printf("Job %s canceled.", new Object[]{jobId});
            }
            catch (IllegalArgumentException e) {
                this.printf("Job %s not WAITING or RUNNING.", new Object[]{jobId});
            }
            catch (IllegalStateException e) {
                this.printf("Error cancelling job %s. %s", new Object[]{jobId, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
    }
}

