/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.worker;

import java.util.Collections;
import java.util.Map;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.jobs.IJobContext;
import org.eclipse.gyrex.jobs.internal.worker.JobInfo;
import org.eclipse.gyrex.jobs.internal.worker.JobLogHelper;
import org.slf4j.Logger;

public class JobContext
implements IJobContext {
    private final Map<String, String> jobProperties;
    private final IRuntimeContext context;
    private final JobInfo info;

    public JobContext(IRuntimeContext context, JobInfo info) {
        this.context = context;
        this.info = info;
        this.jobProperties = Collections.unmodifiableMap(info.getJobProperties());
    }

    @Override
    public IRuntimeContext getContext() {
        return this.context;
    }

    @Override
    public String getJobId() {
        return this.info.getJobId();
    }

    @Override
    public long getLastSuccessfulStart() {
        return this.info.getLastSuccessfulStart();
    }

    @Override
    public Logger getLogger() {
        return JobLogHelper.getLogger(this.info.getJobTypeId(), this.info.getJobId());
    }

    @Override
    public Map<String, String> getParameter() {
        return this.jobProperties;
    }
}

