/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.metrics;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.eclipse.gyrex.monitoring.metrics.BaseMetric;
import org.eclipse.gyrex.monitoring.metrics.MetricAttribute;

public class StatusMetric
extends BaseMetric {
    private volatile String status;
    private volatile String statusChangeReason;
    private volatile long statusChangeTime;
    private volatile long statusStatsChangeCount;

    public StatusMetric(String id, String initialStatus, String initialStatusReason) {
        super(id);
        if (initialStatus == null) {
            throw new IllegalArgumentException("initialStatus may not be null");
        }
        if (initialStatusReason == null) {
            throw new IllegalArgumentException("initialStatusReason change reason may not be null");
        }
        this.status = initialStatus;
        this.statusChangeReason = initialStatusReason;
    }

    @Override
    void doResetStats() {
        this.statusStatsChangeCount = 0L;
    }

    @Override
    Object[] dumpMetrics() {
        return new Object[]{"status|reason|since|total changes", this.getStatus(), this.getStatusChangeReason(), this.getStatusChangeTime(), this.getStatusStatsChangeCount()};
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusChangeReason() {
        return this.statusChangeReason;
    }

    public String getStatusChangeTime() {
        return ISO_8601_UTC.format(new Date(this.statusChangeTime));
    }

    public long getStatusStatsChangeCount() {
        return this.statusStatsChangeCount;
    }

    @Override
    void populateAttributes(List<MetricAttribute> attributes) {
        super.populateAttributes(attributes);
        attributes.add(new MetricAttribute("status", "the status", String.class));
        attributes.add(new MetricAttribute("statusChangeReason", "the reason for the status change", String.class));
        attributes.add(new MetricAttribute("statusChangeTime", "the last status change time", String.class));
        attributes.add(new MetricAttribute("statusStatsChangeCount", "a counter for status changes since the last reset", Long.class));
    }

    @Override
    void populateAttributeValues(Map<String, Object> values) {
        super.populateAttributeValues(values);
        values.put("status", this.getStatus());
        values.put("statusChangeReason", this.getStatusChangeReason());
        values.put("statusChangeTime", this.getStatusChangeTime());
        values.put("statusStatsChangeCount", this.getStatusStatsChangeCount());
    }

    public void setStatus(String status, String statusChangeReason) {
        if (status == null) {
            throw new IllegalArgumentException("status may not be null");
        }
        if (statusChangeReason == null) {
            throw new IllegalArgumentException("status change reason may not be null");
        }
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            this.status = status;
            this.statusChangeReason = statusChangeReason;
            this.statusChangeTime = System.currentTimeMillis();
            ++this.statusStatsChangeCount;
        }
        finally {
            writeLock.unlock();
        }
    }
}

