/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.derby.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.server.Platform;
import org.osgi.framework.BundleContext;

public class DerbyActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.persistence.derby";
    private static final String DERBY_SYSTEM_HOME = "derby.system.home";
    private static final String DERBY_EMBEDDED_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";

    public DerbyActivator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (System.getProperty(DerbyActivator.DERBY_SYSTEM_HOME) == null) {
                    IPath systemBase = Platform.getInstanceLocation().append("derby");
                    if (systemBase == null) {
                        throw new IllegalStateException("The framework must have file system support to use the Derby persistence type.");
                    }
                    System.setProperty(DerbyActivator.DERBY_SYSTEM_HOME, systemBase.toOSString());
                }
                return null;
            }
        });
        try {
            this.getBundle().loadClass(DERBY_EMBEDDED_DRIVER).newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not load Derby database driver: " + e.getMessage());
        }
    }
}

