/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.solr.internal;

import java.net.MalformedURLException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.eclipse.gyrex.persistence.solr.SolrServerRepository;
import org.eclipse.gyrex.persistence.solr.config.SolrServerType;
import org.eclipse.gyrex.persistence.solr.internal.SolrRepository;
import org.eclipse.gyrex.persistence.solr.internal.SolrServerFactory;
import org.eclipse.gyrex.persistence.storage.Repository;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;
import org.osgi.service.prefs.BackingStoreException;

public class SolrRepositoryProvider
extends RepositoryProvider {
    public static final String PREF_KEY_SERVER_TYPE = "serverType";
    public static final String PREF_KEY_SERVER_URL = "serverUrl";
    public static final String PREF_KEY_ZK_HOSTS = "zkHosts";
    public static final String PREF_KEY_SERVER_READ_URLS = "serverReadUrls";

    public SolrRepositoryProvider() {
        super("org.eclipse.gyrex.persistence.solr", SolrServerRepository.class);
    }

    public Repository createRepositoryInstance(String repositoryId, IRepositoryPreferences repositoryPreferences) {
        return new SolrRepository(repositoryId, this, this.createServers(repositoryId, repositoryPreferences));
    }

    private SolrServer[] createServers(String repositoryId, IRepositoryPreferences repositoryPreferences) {
        String typeStr = repositoryPreferences.get(PREF_KEY_SERVER_TYPE, null);
        SolrServerType serverType = typeStr == null ? SolrServerType.EMBEDDED : SolrServerType.valueOf(typeStr);
        switch (serverType) {
            case EMBEDDED: {
                SolrServer embeddedServer = SolrServerFactory.createEmbeddedServer(repositoryId);
                return new SolrServer[]{embeddedServer, embeddedServer};
            }
            case REMOTE: {
                String masterUrlString = repositoryPreferences.get(PREF_KEY_SERVER_URL, null);
                try {
                    SolrServer readServer;
                    SolrServer masterServer = SolrServerFactory.createDefaultSolrServer(masterUrlString);
                    String[] readUrlKeys = repositoryPreferences.getKeys(PREF_KEY_SERVER_READ_URLS);
                    if (readUrlKeys == null || readUrlKeys.length == 0) {
                        readServer = SolrServerFactory.createReadOptimizedServer(masterUrlString);
                    } else if (readUrlKeys.length == 1) {
                        readServer = SolrServerFactory.createReadOptimizedServer(repositoryPreferences.get("serverReadUrls//" + readUrlKeys[0], null));
                    } else {
                        String[] urls = new String[readUrlKeys.length];
                        try {
                            int i = 0;
                            while (i < readUrlKeys.length) {
                                int pos = NumberUtils.toInt((String)readUrlKeys[i], (int)-1);
                                urls[pos] = repositoryPreferences.get("serverReadUrls//" + readUrlKeys[i], null);
                                ++i;
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw new IllegalStateException(String.format("Unable to read replica urls for repository %s. %s", repositoryId, e.getMessage()), e);
                        }
                        readServer = SolrServerFactory.createLoadBalancingReadOptimizedServer(urls);
                    }
                    return new SolrServer[]{masterServer, readServer};
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(String.format("Repository %s not configured correctly. Server URL '%s' is invalid.  %s", repositoryId, masterUrlString, e.getMessage()));
                }
                catch (BackingStoreException e) {
                    throw new IllegalStateException(String.format("Unable to read repository settings for repository %s. %s", repositoryId, e.getMessage()), e);
                }
            }
            case CLOUD: {
                String zkHost = repositoryPreferences.get(PREF_KEY_ZK_HOSTS, null);
                try {
                    SolrServer cloudSolrServer = SolrServerFactory.createCloudSolrServer(zkHost, repositoryId);
                    return new SolrServer[]{cloudSolrServer, cloudSolrServer};
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(String.format("Repository %s not configured correctly. Zookeeper Host(s) '%s' invalid.  %s", repositoryId, zkHost, ExceptionUtils.getRootCauseMessage((Throwable)e)));
                }
            }
        }
        throw new IllegalStateException(String.format("Repository %s not configured correctly. Unsupported server type %s", repositoryId, typeStr));
    }
}

