/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.console;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.persistence.internal.PersistenceActivator;
import org.eclipse.gyrex.persistence.internal.console.BaseRepoSelectingCommand;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryDefinition;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryProviderRegistry;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class LsRepos
extends BaseRepoSelectingCommand {
    @Option(name="-v", aliases={"--verbose"}, usage="prints detailed configuration information")
    protected boolean verbose = false;
    @Argument(index=0, metaVar="ID-SUB-STRING", usage="repository sub-string id filter")
    protected String repositoryIdFilterArg;

    public LsRepos() {
        super("<repoIdFilter> - lists available repositories");
    }

    @Override
    protected String getRepositoryIdFilter() {
        if (this.repositoryIdFilterArg != null) {
            return this.repositoryIdFilterArg;
        }
        return super.getRepositoryIdFilter();
    }

    @Override
    protected void processRepository(String repositoryId) throws Exception {
        RepositoryDefinition definition = this.getRegistry().getRepositoryDefinition(repositoryId);
        String providerId = definition.getProviderId();
        try {
            RepositoryProviderRegistry providerRegistry = PersistenceActivator.getInstance().getRepositoryProviderRegistry();
            String provider = providerRegistry.getRepositoryProviderInfo(providerId);
            this.printf("%s [%s]", new Object[]{repositoryId, StringUtils.trimToEmpty((String)provider)});
            if (this.verbose) {
                String[] keys;
                IRepositoryPreferences repositoryPreferences = definition.getRepositoryPreferences();
                String[] stringArray = keys = repositoryPreferences.getKeys("");
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    this.printf("\t%20s: %s", new Object[]{key, StringUtils.trimToEmpty((String)repositoryPreferences.get(key, null))});
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            this.printf("%s [ERROR] %s", new Object[]{repositoryId, ExceptionUtils.getRootCauseMessage((Throwable)e)});
        }
    }
}

