/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences.internal.console;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.preferences.internal.util.EclipsePreferencesUtil;
import org.kohsuke.args4j.Argument;
import org.osgi.service.prefs.Preferences;

public class UnsetCmd
extends Command {
    @Argument(index=0, required=true, metaVar="PATH", usage="path to a preference key")
    String path;

    public UnsetCmd() {
        super("<path> - unsets a preference key");
    }

    protected void doExecute() throws Exception {
        IPreferencesService preferencesService = EclipsePreferencesUtil.getPreferencesService();
        String[] decodedPath = EclipsePreferencesUtil.decodePath(StringUtils.trimToEmpty((String)this.path));
        Preferences node = preferencesService.getRootNode().node(StringUtils.trimToEmpty((String)decodedPath[0]));
        node.remove(decodedPath[1]);
        node.flush();
        this.printf("Unset property '%s' at '%s'", new Object[]{StringUtils.trimToEmpty((String)decodedPath[1]), StringUtils.trimToEmpty((String)decodedPath[0])});
    }
}

