/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.rap.application;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.eclipse.gyrex.common.identifiers.IdHelper;

public abstract class PageHandle
implements Comparable<PageHandle> {
    private static final String[] NO_KEYWORDS = new String[0];
    private final String id;
    private String[] keywords;
    private String name;
    private String sortKey;
    private String categoryId;

    public PageHandle(String id) {
        Preconditions.checkArgument((boolean)IdHelper.isValidId((String)id), (Object)"id is invalid");
        this.id = id;
    }

    @Override
    public int compareTo(PageHandle o) {
        return this.getSortKey().compareTo(o.getSortKey());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PageHandle)) {
            return false;
        }
        PageHandle other = (PageHandle)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getId() {
        return this.id;
    }

    public String[] getKeywords() {
        if (this.keywords == null) {
            return NO_KEYWORDS;
        }
        return this.keywords;
    }

    public String getName() {
        String name = this.name;
        return name != null ? name : this.getId();
    }

    public String getSortKey() {
        String value = this.sortKey;
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        value = this.getName();
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return this.getId();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public String toString() {
        return "PageHandle [" + this.id + ", " + this.name + "]";
    }
}

