/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.rap.application;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.gyrex.rap.application.Category;
import org.eclipse.gyrex.rap.application.Page;
import org.eclipse.gyrex.rap.application.PageHandle;

public abstract class PageProvider {
    private final ConcurrentMap<String, PageHandle> pagesById = new ConcurrentHashMap<String, PageHandle>();
    private final ConcurrentMap<String, Category> categoriesById = new ConcurrentHashMap<String, Category>(4);
    private volatile Map<String, Set<PageHandle>> pagesByCategoryId;

    protected boolean addCategory(Category category) {
        Preconditions.checkArgument((category != null ? 1 : 0) != 0, (Object)"category must not be null");
        String id = category.getId();
        if (this.categoriesById.putIfAbsent(id, category) != null) {
            return false;
        }
        this.rebuildPagesByCategories();
        return true;
    }

    protected boolean addPage(PageHandle page) {
        Preconditions.checkArgument((page != null ? 1 : 0) != 0, (Object)"page must not be null");
        String id = page.getId();
        if (this.pagesById.putIfAbsent(id, page) != null) {
            return false;
        }
        this.rebuildPagesByCategories();
        return true;
    }

    public abstract Page createPage(PageHandle var1) throws Exception;

    public List<Category> getCategories() {
        if (this.categoriesById.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<Category>(this.categoriesById.values());
    }

    public PageHandle getPage(String id) {
        return (PageHandle)this.pagesById.get(id);
    }

    public List<PageHandle> getPages(Category category) {
        Map<String, Set<PageHandle>> mappings = this.pagesByCategoryId;
        if (mappings == null || mappings.isEmpty()) {
            return Collections.emptyList();
        }
        Set<PageHandle> children = mappings.get(category.getId());
        if (children == null || children.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<PageHandle>(children);
    }

    boolean hasPages(Category category) {
        if (category == null) {
            return false;
        }
        Map<String, Set<PageHandle>> mappings = this.pagesByCategoryId;
        if (mappings == null) {
            return false;
        }
        Set<PageHandle> children = mappings.get(category.getId());
        return children != null && !children.isEmpty();
    }

    private void rebuildPagesByCategories() {
        HashMap<String, Set<PageHandle>> mappings = new HashMap<String, Set<PageHandle>>();
        Collection values = this.pagesById.values();
        for (PageHandle page : values) {
            if (!mappings.containsKey(page.getCategoryId())) {
                mappings.put(page.getCategoryId(), new HashSet());
            }
            ((Set)mappings.get(page.getCategoryId())).add(page);
        }
        this.pagesByCategoryId = mappings;
    }

    protected void removeCategory(String id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"category id must not be null");
        if (this.categoriesById.remove(id) != null) {
            this.rebuildPagesByCategories();
        }
    }

    protected void removePage(String id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"page id must not be null");
        if (this.pagesById.remove(id) != null) {
            this.rebuildPagesByCategories();
        }
    }
}

