/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.search.internal.solr.documents;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.common.SolrInputDocument;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.monitoring.metrics.ThroughputMetric;
import org.eclipse.gyrex.search.documents.IDocument;
import org.eclipse.gyrex.search.documents.IDocumentAttribute;
import org.eclipse.gyrex.search.internal.SearchActivator;
import org.eclipse.gyrex.search.internal.solr.SolrSearchManagerMetrics;

public class PublishJob
extends Job {
    public static final Object FAMILY = new Object();
    private final Iterable<IDocument> documents;
    private final SolrServer solrServer;
    private final SolrSearchManagerMetrics solrListingsManagerMetrics;
    private final boolean commit;

    public PublishJob(Iterable<IDocument> documents, SolrServer solrServer, SolrSearchManagerMetrics solrListingsManagerMetrics, boolean commit) {
        super("Solr Document Publish");
        this.documents = documents;
        this.solrServer = solrServer;
        this.solrListingsManagerMetrics = solrListingsManagerMetrics;
        this.commit = commit;
        this.setSystem(true);
        this.setPriority(30);
    }

    public boolean belongsTo(Object family) {
        return FAMILY == family;
    }

    private SolrInputDocument createSolrDoc(IDocument document) {
        SolrInputDocument solrDoc = new SolrInputDocument();
        Collection<IDocumentAttribute<?>> attributes = document.getAttributes().values();
        for (IDocumentAttribute<?> attr : attributes) {
            Collection<?> values = attr.getValues();
            for (Object value : values) {
                solrDoc.addField(attr.getId(), value);
            }
        }
        return solrDoc;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            SearchActivator.getInstance();
        }
        catch (IllegalStateException e) {
            return Status.CANCEL_STATUS;
        }
        ThroughputMetric publishedMetric = this.solrListingsManagerMetrics.getDocsPublishedMetric();
        long requestStarted = publishedMetric.requestStarted();
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
        for (IDocument document : this.documents) {
            docs.add(this.createSolrDoc(document));
        }
        try {
            if (this.commit) {
                this.solrServer.add(docs);
                this.solrServer.commit();
            } else {
                this.solrServer.add(docs);
            }
            publishedMetric.requestFinished((long)docs.size(), System.currentTimeMillis() - requestStarted);
        }
        catch (Exception e) {
            publishedMetric.requestFailed();
            return new Status(4, "org.eclipse.gyrex.search", "error while submitting documents to Solr", (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

